/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.buffer;

import java.util.Iterator;
import java.util.function.Function;
import org.tensorflow.ndarray.NdArray;

public class ByteSequenceProvider<T>
implements Iterable<byte[]> {
    private final NdArray<T> source;
    private final Function<T, byte[]> byteExtractor;

    public ByteSequenceProvider(NdArray<T> source, Function<T, byte[]> byteExtractor) {
        this.source = source;
        this.byteExtractor = byteExtractor;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            private final Iterator<? extends NdArray<T>> scalarIterator;
            {
                this.scalarIterator = ByteSequenceProvider.this.source.scalars().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.scalarIterator.hasNext();
            }

            @Override
            public byte[] next() {
                return ByteSequenceProvider.this.byteExtractor.apply(this.scalarIterator.next().getObject(new long[0]));
            }
        };
    }

    long numSequences() {
        return this.source.size();
    }
}

