/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse.slice;

import java.nio.ReadOnlyBufferException;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArraySequence;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.dimension.RelativeDimensionalSpace;
import org.tensorflow.ndarray.impl.sequence.SingleElementSequence;
import org.tensorflow.ndarray.impl.sequence.SlicingElementSequence;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.index.Index;

public abstract class SparseSlice<T, U extends NdArray<T>>
extends AbstractSparseNdArray<T, U> {
    protected final AbstractSparseNdArray<T, U> source;
    protected final long sourcePosition;

    public SparseSlice(AbstractSparseNdArray<T, U> source, long sourcePosition, DimensionalSpace dimensions) {
        super(source.getDefaultValue(), dimensions);
        this.source = source;
        this.sourcePosition = sourcePosition;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.source.hashCode();
        result = 31 * result + (int)this.sourcePosition;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SparseSlice)) {
            return super.equals(obj);
        }
        SparseSlice other = (SparseSlice)obj;
        if (!this.source.equals(other.source)) {
            return false;
        }
        if (!this.shape().equals(other.shape())) {
            return false;
        }
        return this.sourcePosition == other.sourcePosition;
    }

    @Override
    public T getObject(long ... coordinates) {
        long position = this.dimensions().positionOf(coordinates);
        long[] sourceCoordinates = this.toCoordinates(this.source.dimensions(), this.sourcePosition + position);
        return this.source.getObject(sourceCoordinates);
    }

    @Override
    public NdArray<T> get(long ... coordinates) {
        long position = this.dimensions().positionOf(coordinates);
        long[] sourceCoordinates = this.toCoordinates(this.source.dimensions(), this.sourcePosition + position);
        return this.source.get(sourceCoordinates);
    }

    @Override
    public NdArray<T> slice(Index ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Slicing requires at least one index");
        }
        RelativeDimensionalSpace sliceDimensions = this.dimensions().mapTo(indices);
        return this.slice(sliceDimensions.position(), sliceDimensions);
    }

    @Override
    public NdArraySequence<U> elements(int dimensionIdx) {
        if (dimensionIdx >= this.shape().numDimensions()) {
            throw new IllegalArgumentException("Cannot iterate elements in dimension '" + dimensionIdx + "' of array with shape " + this.shape());
        }
        if (this.rank() == 0 && dimensionIdx < 0) {
            return new SingleElementSequence(this);
        }
        DimensionalSpace elemDims = this.dimensions().from(dimensionIdx + 1);
        return new SlicingElementSequence(this, dimensionIdx, elemDims);
    }

    @Override
    public abstract U toDense();

    @Override
    public NdArray<T> write(DataBuffer<T> src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public U createValues(Shape shape) {
        return this.source.createValues(shape);
    }
}

