/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;

@OpMetadata(opType="FakeQuantWithMinMaxArgs", inputsClass=Inputs.class)
public final class FakeQuantWithMinMaxArgs
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "FakeQuantWithMinMaxArgs";
    private Output<TFloat32> outputs;

    public FakeQuantWithMinMaxArgs(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputs = operation.output(outputIdx++);
    }

    public static FakeQuantWithMinMaxArgs create(Scope scope, Operand<TFloat32> inputs, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputs.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.min != null) {
                    opBuilder.setAttr("min", opts.min.floatValue());
                }
                if (opts.max != null) {
                    opBuilder.setAttr("max", opts.max.floatValue());
                }
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.narrowRange == null) continue;
                opBuilder.setAttr("narrow_range", opts.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxArgs(opBuilder.build());
    }

    public static Options min(Float min) {
        return new Options().min(min);
    }

    public static Options max(Float max) {
        return new Options().max(max);
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public Output<TFloat32> outputs() {
        return this.outputs;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.outputs;
    }

    @OpInputsMetadata(outputsClass=FakeQuantWithMinMaxArgs.class)
    public static class Inputs
    extends RawOpInputs<FakeQuantWithMinMaxArgs> {
        public final Operand<TFloat32> inputs;
        public final float min;
        public final float max;
        public final long numBits;
        public final boolean narrowRange;

        public Inputs(GraphOperation op) {
            super(new FakeQuantWithMinMaxArgs(op), op, Arrays.asList("min", "max", "num_bits", "narrow_range"));
            int inputIndex = 0;
            this.inputs = op.input(inputIndex++);
            this.min = op.attributes().getAttrFloat("min");
            this.max = op.attributes().getAttrFloat("max");
            this.numBits = op.attributes().getAttrInt("num_bits");
            this.narrowRange = op.attributes().getAttrBool("narrow_range");
        }
    }

    public static class Options {
        private Float min;
        private Float max;
        private Long numBits;
        private Boolean narrowRange;

        private Options() {
        }

        public Options min(Float min) {
            this.min = min;
            return this;
        }

        public Options max(Float max) {
            this.max = max;
            return this;
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }
    }
}

