/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="ResizeArea", inputsClass=Inputs.class)
public final class ResizeArea
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "ResizeArea";
    private Output<TFloat32> resizedImages;

    public ResizeArea(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.resizedImages = operation.output(outputIdx++);
    }

    public static ResizeArea create(Scope scope, Operand<? extends TNumber> images, Operand<TInt32> sizeOutput, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(sizeOutput.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.alignCorners == null) continue;
                opBuilder.setAttr("align_corners", opts.alignCorners);
            }
        }
        return new ResizeArea(opBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public Output<TFloat32> resizedImages() {
        return this.resizedImages;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.resizedImages;
    }

    @OpInputsMetadata(outputsClass=ResizeArea.class)
    public static class Inputs
    extends RawOpInputs<ResizeArea> {
        public final Operand<? extends TNumber> images;
        public final Operand<TInt32> sizeOutput;
        public final DataType T;
        public final boolean alignCorners;

        public Inputs(GraphOperation op) {
            super(new ResizeArea(op), op, Arrays.asList("T", "align_corners"));
            int inputIndex = 0;
            this.images = op.input(inputIndex++);
            this.sizeOutput = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.alignCorners = op.attributes().getAttrBool("align_corners");
        }
    }

    public static class Options {
        private Boolean alignCorners;

        private Options() {
        }

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }
    }
}

