/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BatchFunction", inputsClass=Inputs.class)
public final class BatchFunction
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "BatchFunction";
    private List<Output<?>> outTensors;

    public BatchFunction(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outTensorsLength = operation.outputListLength("out_tensors");
        this.outTensors = Arrays.asList(operation.outputList(outputIdx, outTensorsLength));
        outputIdx += outTensorsLength;
    }

    public static BatchFunction create(Scope scope, Iterable<Operand<?>> inTensors, Iterable<Operand<?>> capturedTensors, ConcreteFunction f, Long numBatchThreads, Long maxBatchSize, Long batchTimeoutMicros, List<Class<? extends TType>> Tout, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(inTensors));
        opBuilder.addInputList(Operands.asOutputs(capturedTensors));
        opBuilder.setAttr("f", f);
        opBuilder.setAttr("num_batch_threads", numBatchThreads);
        opBuilder.setAttr("max_batch_size", maxBatchSize);
        opBuilder.setAttr("batch_timeout_micros", batchTimeoutMicros);
        opBuilder.setAttr("Tout", Operands.toDataTypes(Tout));
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxEnqueuedBatches != null) {
                    opBuilder.setAttr("max_enqueued_batches", opts.maxEnqueuedBatches);
                }
                if (opts.allowedBatchSizes != null) {
                    long[] allowedBatchSizesArray = new long[opts.allowedBatchSizes.size()];
                    for (int i = 0; i < allowedBatchSizesArray.length; ++i) {
                        allowedBatchSizesArray[i] = (Long)opts.allowedBatchSizes.get(i);
                    }
                    opBuilder.setAttr("allowed_batch_sizes", allowedBatchSizesArray);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.batchingQueue != null) {
                    opBuilder.setAttr("batching_queue", opts.batchingQueue);
                }
                if (opts.enableLargeBatchSplitting == null) continue;
                opBuilder.setAttr("enable_large_batch_splitting", opts.enableLargeBatchSplitting);
            }
        }
        return new BatchFunction(opBuilder.build());
    }

    public static Options maxEnqueuedBatches(Long maxEnqueuedBatches) {
        return new Options().maxEnqueuedBatches(maxEnqueuedBatches);
    }

    public static Options allowedBatchSizes(List<Long> allowedBatchSizes) {
        return new Options().allowedBatchSizes(allowedBatchSizes);
    }

    public static Options allowedBatchSizes(Long ... allowedBatchSizes) {
        return new Options().allowedBatchSizes(allowedBatchSizes);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options batchingQueue(String batchingQueue) {
        return new Options().batchingQueue(batchingQueue);
    }

    public static Options enableLargeBatchSplitting(Boolean enableLargeBatchSplitting) {
        return new Options().enableLargeBatchSplitting(enableLargeBatchSplitting);
    }

    public List<Output<?>> outTensors() {
        return this.outTensors;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.outTensors.iterator();
    }

    @OpInputsMetadata(outputsClass=BatchFunction.class)
    public static class Inputs
    extends RawOpInputs<BatchFunction> {
        public final Iterable<Operand<?>> inTensors;
        public final Iterable<Operand<?>> capturedTensors;
        public final long numBatchThreads;
        public final long maxBatchSize;
        public final long batchTimeoutMicros;
        public final long maxEnqueuedBatches;
        public final long[] allowedBatchSizes;
        public final String container;
        public final String sharedName;
        public final String batchingQueue;
        public final DataType[] Tin;
        public final DataType[] Tcaptured;
        public final DataType[] Tout;
        public final boolean enableLargeBatchSplitting;

        public Inputs(GraphOperation op) {
            super(new BatchFunction(op), op, Arrays.asList("num_batch_threads", "max_batch_size", "batch_timeout_micros", "max_enqueued_batches", "allowed_batch_sizes", "container", "shared_name", "batching_queue", "Tin", "Tcaptured", "Tout", "enable_large_batch_splitting"));
            int inputIndex = 0;
            int inTensorsLength = op.inputListLength("in_tensors");
            this.inTensors = Arrays.asList((Operand[])op.inputList(inputIndex, inTensorsLength));
            int capturedTensorsLength = op.inputListLength("captured_tensors");
            this.capturedTensors = Arrays.asList((Operand[])op.inputList(inputIndex += inTensorsLength, capturedTensorsLength));
            inputIndex += capturedTensorsLength;
            this.numBatchThreads = op.attributes().getAttrInt("num_batch_threads");
            this.maxBatchSize = op.attributes().getAttrInt("max_batch_size");
            this.batchTimeoutMicros = op.attributes().getAttrInt("batch_timeout_micros");
            this.maxEnqueuedBatches = op.attributes().getAttrInt("max_enqueued_batches");
            this.allowedBatchSizes = op.attributes().getAttrIntList("allowed_batch_sizes");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
            this.batchingQueue = op.attributes().getAttrString("batching_queue");
            this.Tin = op.attributes().getAttrTypeList("Tin");
            this.Tcaptured = op.attributes().getAttrTypeList("Tcaptured");
            this.Tout = op.attributes().getAttrTypeList("Tout");
            this.enableLargeBatchSplitting = op.attributes().getAttrBool("enable_large_batch_splitting");
        }
    }

    public static class Options {
        private Long maxEnqueuedBatches;
        private List<Long> allowedBatchSizes;
        private String container;
        private String sharedName;
        private String batchingQueue;
        private Boolean enableLargeBatchSplitting;

        private Options() {
        }

        public Options maxEnqueuedBatches(Long maxEnqueuedBatches) {
            this.maxEnqueuedBatches = maxEnqueuedBatches;
            return this;
        }

        public Options allowedBatchSizes(List<Long> allowedBatchSizes) {
            this.allowedBatchSizes = allowedBatchSizes;
            return this;
        }

        public Options allowedBatchSizes(Long ... allowedBatchSizes) {
            this.allowedBatchSizes = Arrays.asList(allowedBatchSizes);
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options batchingQueue(String batchingQueue) {
            this.batchingQueue = batchingQueue;
            return this;
        }

        public Options enableLargeBatchSplitting(Boolean enableLargeBatchSplitting) {
            this.enableLargeBatchSplitting = enableLargeBatchSplitting;
            return this;
        }
    }
}

