/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="EnqueueTPUEmbeddingSparseTensorBatch", inputsClass=Inputs.class)
public final class EnqueueTPUEmbeddingSparseTensorBatch
extends RawOp {
    public static final String OP_NAME = "EnqueueTPUEmbeddingSparseTensorBatch";

    public EnqueueTPUEmbeddingSparseTensorBatch(Operation operation) {
        super(operation, OP_NAME);
    }

    public static EnqueueTPUEmbeddingSparseTensorBatch create(Scope scope, Iterable<Operand<? extends TNumber>> sampleIndices, Iterable<Operand<? extends TNumber>> embeddingIndices, Iterable<Operand<? extends TNumber>> aggregationWeights, Operand<TString> modeOverride, List<Long> tableIds, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(sampleIndices));
        opBuilder.addInputList(Operands.asOutputs(embeddingIndices));
        opBuilder.addInputList(Operands.asOutputs(aggregationWeights));
        opBuilder.addInput(modeOverride.asOutput());
        long[] tableIdsArray = new long[tableIds.size()];
        for (int i = 0; i < tableIdsArray.length; ++i) {
            tableIdsArray[i] = tableIds.get(i);
        }
        opBuilder.setAttr("table_ids", tableIdsArray);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.deviceOrdinal != null) {
                    opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
                }
                if (opts.combiners != null) {
                    String[] combinersArray = new String[opts.combiners.size()];
                    for (i = 0; i < combinersArray.length; ++i) {
                        combinersArray[i] = (String)opts.combiners.get(i);
                    }
                    opBuilder.setAttr("combiners", combinersArray);
                }
                if (opts.maxSequenceLengths != null) {
                    long[] maxSequenceLengthsArray = new long[opts.maxSequenceLengths.size()];
                    for (i = 0; i < maxSequenceLengthsArray.length; ++i) {
                        maxSequenceLengthsArray[i] = (Long)opts.maxSequenceLengths.get(i);
                    }
                    opBuilder.setAttr("max_sequence_lengths", maxSequenceLengthsArray);
                }
                if (opts.numFeatures == null) continue;
                long[] numFeaturesArray = new long[opts.numFeatures.size()];
                for (i = 0; i < numFeaturesArray.length; ++i) {
                    numFeaturesArray[i] = (Long)opts.numFeatures.get(i);
                }
                opBuilder.setAttr("num_features", numFeaturesArray);
            }
        }
        return new EnqueueTPUEmbeddingSparseTensorBatch(opBuilder.build());
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    public static Options combiners(List<String> combiners) {
        return new Options().combiners(combiners);
    }

    public static Options combiners(String ... combiners) {
        return new Options().combiners(combiners);
    }

    public static Options maxSequenceLengths(List<Long> maxSequenceLengths) {
        return new Options().maxSequenceLengths(maxSequenceLengths);
    }

    public static Options maxSequenceLengths(Long ... maxSequenceLengths) {
        return new Options().maxSequenceLengths(maxSequenceLengths);
    }

    public static Options numFeatures(List<Long> numFeatures) {
        return new Options().numFeatures(numFeatures);
    }

    public static Options numFeatures(Long ... numFeatures) {
        return new Options().numFeatures(numFeatures);
    }

    @OpInputsMetadata(outputsClass=EnqueueTPUEmbeddingSparseTensorBatch.class)
    public static class Inputs
    extends RawOpInputs<EnqueueTPUEmbeddingSparseTensorBatch> {
        public final Iterable<Operand<? extends TNumber>> sampleIndices;
        public final Iterable<Operand<? extends TNumber>> embeddingIndices;
        public final Iterable<Operand<? extends TNumber>> aggregationWeights;
        public final Operand<TString> modeOverride;
        public final DataType T1;
        public final DataType T2;
        public final DataType T3;
        public final long deviceOrdinal;
        public final String[] combiners;
        public final long[] tableIds;
        public final long[] maxSequenceLengths;
        public final long[] numFeatures;

        public Inputs(GraphOperation op) {
            super(new EnqueueTPUEmbeddingSparseTensorBatch(op), op, Arrays.asList("T1", "T2", "T3", "device_ordinal", "combiners", "table_ids", "max_sequence_lengths", "num_features"));
            int inputIndex = 0;
            int sampleIndicesLength = op.inputListLength("sample_indices");
            this.sampleIndices = Arrays.asList((Operand[])op.inputList(inputIndex, sampleIndicesLength));
            int embeddingIndicesLength = op.inputListLength("embedding_indices");
            this.embeddingIndices = Arrays.asList((Operand[])op.inputList(inputIndex += sampleIndicesLength, embeddingIndicesLength));
            int aggregationWeightsLength = op.inputListLength("aggregation_weights");
            this.aggregationWeights = Arrays.asList((Operand[])op.inputList(inputIndex += embeddingIndicesLength, aggregationWeightsLength));
            inputIndex += aggregationWeightsLength;
            this.modeOverride = op.input(inputIndex++);
            this.T1 = op.attributes().getAttrType("T1");
            this.T2 = op.attributes().getAttrType("T2");
            this.T3 = op.attributes().getAttrType("T3");
            this.deviceOrdinal = op.attributes().getAttrInt("device_ordinal");
            this.combiners = op.attributes().getAttrStringList("combiners");
            this.tableIds = op.attributes().getAttrIntList("table_ids");
            this.maxSequenceLengths = op.attributes().getAttrIntList("max_sequence_lengths");
            this.numFeatures = op.attributes().getAttrIntList("num_features");
        }
    }

    public static class Options {
        private Long deviceOrdinal;
        private List<String> combiners;
        private List<Long> maxSequenceLengths;
        private List<Long> numFeatures;

        private Options() {
        }

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }

        public Options combiners(List<String> combiners) {
            this.combiners = combiners;
            return this;
        }

        public Options combiners(String ... combiners) {
            this.combiners = Arrays.asList(combiners);
            return this;
        }

        public Options maxSequenceLengths(List<Long> maxSequenceLengths) {
            this.maxSequenceLengths = maxSequenceLengths;
            return this;
        }

        public Options maxSequenceLengths(Long ... maxSequenceLengths) {
            this.maxSequenceLengths = Arrays.asList(maxSequenceLengths);
            return this;
        }

        public Options numFeatures(List<Long> numFeatures) {
            this.numFeatures = numFeatures;
            return this;
        }

        public Options numFeatures(Long ... numFeatures) {
            this.numFeatures = Arrays.asList(numFeatures);
            return this;
        }
    }
}

