/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.risc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RiscWhile", inputsClass=Inputs.class)
public final class RiscWhile
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "RiscWhile";
    private List<Output<?>> output;

    public RiscWhile(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static RiscWhile create(Scope scope, Iterable<Operand<?>> input, ConcreteFunction cond, ConcreteFunction body, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(input));
        opBuilder.setAttr("cond", cond);
        opBuilder.setAttr("body", body);
        if (options != null) {
            for (Options opts : options) {
                if (opts.outputShapes != null) {
                    Shape[] outputShapesArray = new Shape[opts.outputShapes.size()];
                    for (int i = 0; i < outputShapesArray.length; ++i) {
                        outputShapesArray[i] = (Shape)opts.outputShapes.get(i);
                    }
                    opBuilder.setAttr("output_shapes", outputShapesArray);
                }
                if (opts.parallelIterations == null) continue;
                opBuilder.setAttr("parallel_iterations", opts.parallelIterations);
            }
        }
        return new RiscWhile(opBuilder.build());
    }

    public static Options outputShapes(List<Shape> outputShapes) {
        return new Options().outputShapes(outputShapes);
    }

    public static Options outputShapes(Shape ... outputShapes) {
        return new Options().outputShapes(outputShapes);
    }

    public static Options parallelIterations(Long parallelIterations) {
        return new Options().parallelIterations(parallelIterations);
    }

    public List<Output<?>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=RiscWhile.class)
    public static class Inputs
    extends RawOpInputs<RiscWhile> {
        public final Iterable<Operand<?>> input;
        public final DataType[] T;
        public final Shape[] outputShapes;
        public final long parallelIterations;

        public Inputs(GraphOperation op) {
            super(new RiscWhile(op), op, Arrays.asList("T", "output_shapes", "parallel_iterations"));
            int inputIndex = 0;
            int inputLength = op.inputListLength("input");
            this.input = Arrays.asList((Operand[])op.inputList(inputIndex, inputLength));
            inputIndex += inputLength;
            this.T = op.attributes().getAttrTypeList("T");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.parallelIterations = op.attributes().getAttrInt("parallel_iterations");
        }
    }

    public static class Options {
        private List<Shape> outputShapes;
        private Long parallelIterations;

        private Options() {
        }

        public Options outputShapes(List<Shape> outputShapes) {
            this.outputShapes = outputShapes;
            return this;
        }

        public Options outputShapes(Shape ... outputShapes) {
            this.outputShapes = Arrays.asList(outputShapes);
            return this;
        }

        public Options parallelIterations(Long parallelIterations) {
            this.parallelIterations = parallelIterations;
            return this;
        }
    }
}

