/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DecodeProtoV2", inputsClass=Inputs.class)
public final class DecodeProto
extends RawOp {
    public static final String OP_NAME = "DecodeProtoV2";
    private Output<TInt32> sizes;
    private List<Output<?>> values;

    public DecodeProto(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sizes = operation.output(outputIdx++);
        int valuesLength = operation.outputListLength("values");
        this.values = Arrays.asList(operation.outputList(outputIdx, valuesLength));
        outputIdx += valuesLength;
    }

    public static DecodeProto create(Scope scope, Operand<TString> bytes, String messageType, List<String> fieldNames, List<Class<? extends TType>> outputTypes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "DecodeProto");
        opBuilder.addInput(bytes.asOutput());
        opBuilder.setAttr("message_type", messageType);
        String[] fieldNamesArray = new String[fieldNames.size()];
        for (int i = 0; i < fieldNamesArray.length; ++i) {
            fieldNamesArray[i] = fieldNames.get(i);
        }
        opBuilder.setAttr("field_names", fieldNamesArray);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        if (options != null) {
            for (Options opts : options) {
                if (opts.descriptorSource != null) {
                    opBuilder.setAttr("descriptor_source", opts.descriptorSource);
                }
                if (opts.messageFormat != null) {
                    opBuilder.setAttr("message_format", opts.messageFormat);
                }
                if (opts.sanitize == null) continue;
                opBuilder.setAttr("sanitize", opts.sanitize);
            }
        }
        return new DecodeProto(opBuilder.build());
    }

    public static Options descriptorSource(String descriptorSource) {
        return new Options().descriptorSource(descriptorSource);
    }

    public static Options messageFormat(String messageFormat) {
        return new Options().messageFormat(messageFormat);
    }

    public static Options sanitize(Boolean sanitize) {
        return new Options().sanitize(sanitize);
    }

    public Output<TInt32> sizes() {
        return this.sizes;
    }

    public List<Output<?>> values() {
        return this.values;
    }

    @OpInputsMetadata(outputsClass=DecodeProto.class)
    public static class Inputs
    extends RawOpInputs<DecodeProto> {
        public final Operand<TString> bytes;
        public final String messageType;
        public final String[] fieldNames;
        public final DataType[] outputTypes;
        public final String descriptorSource;
        public final String messageFormat;
        public final boolean sanitize;

        public Inputs(GraphOperation op) {
            super(new DecodeProto(op), op, Arrays.asList("message_type", "field_names", "output_types", "descriptor_source", "message_format", "sanitize"));
            int inputIndex = 0;
            this.bytes = op.input(inputIndex++);
            this.messageType = op.attributes().getAttrString("message_type");
            this.fieldNames = op.attributes().getAttrStringList("field_names");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.descriptorSource = op.attributes().getAttrString("descriptor_source");
            this.messageFormat = op.attributes().getAttrString("message_format");
            this.sanitize = op.attributes().getAttrBool("sanitize");
        }
    }

    public static class Options {
        private String descriptorSource;
        private String messageFormat;
        private Boolean sanitize;

        private Options() {
        }

        public Options descriptorSource(String descriptorSource) {
            this.descriptorSource = descriptorSource;
            return this;
        }

        public Options messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        public Options sanitize(Boolean sanitize) {
            this.sanitize = sanitize;
            return this;
        }
    }
}

