/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorSliceDataset", inputsClass=Inputs.class)
public final class TensorSliceDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "TensorSliceDataset";
    private Output<? extends TType> handle;

    public TensorSliceDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static TensorSliceDataset create(Scope scope, Iterable<Operand<?>> components, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(components));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.isFiles != null) {
                    opBuilder.setAttr("is_files", opts.isFiles);
                }
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new TensorSliceDataset(opBuilder.build());
    }

    public static Options isFiles(Boolean isFiles) {
        return new Options().isFiles(isFiles);
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=TensorSliceDataset.class)
    public static class Inputs
    extends RawOpInputs<TensorSliceDataset> {
        public final Iterable<Operand<?>> components;
        public final DataType[] ToutputTypes;
        public final Shape[] outputShapes;
        public final boolean isFiles;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new TensorSliceDataset(op), op, Arrays.asList("Toutput_types", "output_shapes", "is_files", "metadata"));
            int inputIndex = 0;
            int componentsLength = op.inputListLength("components");
            this.components = Arrays.asList((Operand[])op.inputList(inputIndex, componentsLength));
            inputIndex += componentsLength;
            this.ToutputTypes = op.attributes().getAttrTypeList("Toutput_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.isFiles = op.attributes().getAttrBool("is_files");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private Boolean isFiles;
        private String metadata;

        private Options() {
        }

        public Options isFiles(Boolean isFiles) {
            this.isFiles = isFiles;
            return this;
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

