/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class DeserializeSparse<U extends TType>
extends RawOp {
    public static final String OP_NAME = "DeserializeSparse";
    private Output<TInt64> sparseIndices;
    private Output<U> sparseValues;
    private Output<TInt64> sparseShape;

    public static <U extends TType> DeserializeSparse<U> create(Scope scope, Operand<? extends TType> serializedSparse, Class<U> dtype) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(serializedSparse.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new DeserializeSparse<U>(opBuilder.build());
    }

    public Output<TInt64> sparseIndices() {
        return this.sparseIndices;
    }

    public Output<U> sparseValues() {
        return this.sparseValues;
    }

    public Output<TInt64> sparseShape() {
        return this.sparseShape;
    }

    private DeserializeSparse(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.sparseIndices = operation.output(outputIdx++);
        this.sparseValues = operation.output(outputIdx++);
        this.sparseShape = operation.output(outputIdx++);
    }
}

