/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

public final class FusedResizeAndPadConv2d<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "FusedResizeAndPadConv2D";
    private Output<T> output;

    public static <T extends TNumber> FusedResizeAndPadConv2d<T> create(Scope scope, Operand<T> input, Operand<TInt32> size, Operand<TInt32> paddings, Operand<T> filter, String mode, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("FusedResizeAndPadConv2d"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(size.asOutput());
        opBuilder.addInput(paddings.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("mode", mode);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.resizeAlignCorners == null) continue;
                opBuilder.setAttr("resize_align_corners", opts.resizeAlignCorners);
            }
        }
        return new FusedResizeAndPadConv2d<T>(opBuilder.build());
    }

    public static Options resizeAlignCorners(Boolean resizeAlignCorners) {
        return new Options().resizeAlignCorners(resizeAlignCorners);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private FusedResizeAndPadConv2d(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean resizeAlignCorners;

        public Options resizeAlignCorners(Boolean resizeAlignCorners) {
            this.resizeAlignCorners = resizeAlignCorners;
            return this;
        }

        private Options() {
        }
    }
}

