/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import org.tensorflow.Graph;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;
import org.tensorflow.Signature;
import org.tensorflow.Tensor;
import org.tensorflow.op.Ops;
import org.tensorflow.proto.framework.SignatureDef;
import org.tensorflow.proto.framework.TensorInfo;

public class ConcreteFunction
implements AutoCloseable {
    private final Graph graph;
    private final Session session;
    private final Signature signature;
    private final Ownership ownership;

    public static ConcreteFunction create(Function<Ops, Signature> functionBuilder) {
        Graph graph = new Graph();
        try {
            Ops tf = Ops.create(graph);
            Signature signature = functionBuilder.apply(tf);
            return new ConcreteFunction(signature, graph, new Session(graph), Ownership.GRAPH_AND_SESSION);
        }
        catch (Exception e) {
            graph.close();
            throw e;
        }
    }

    public static ConcreteFunction create(Signature signature, Graph graph) {
        return new ConcreteFunction(signature, graph, new Session(graph), Ownership.SESSION_ONLY);
    }

    public static ConcreteFunction create(Signature signature, Session session) {
        return new ConcreteFunction(signature, session.graph(), session, Ownership.NONE);
    }

    public Signature signature() {
        return this.signature;
    }

    public Map<String, Tensor> call(Map<String, Tensor> arguments) throws IllegalArgumentException {
        SignatureDef signatureDef = this.signature.asSignatureDef();
        Session.Runner runner = this.session.runner();
        signatureDef.getInputsMap().forEach((argName, t) -> {
            Tensor tensor = (Tensor)arguments.get(argName);
            if (tensor == null) {
                throw new IllegalArgumentException(String.format("Missing argument [%s]", argName));
            }
            runner.feed(t.getName(), tensor);
        });
        Map<String, TensorInfo> outputToNode = signatureDef.getOutputsMap();
        outputToNode.values().forEach(t -> runner.fetch(t.getName()));
        List<Tensor> resultTensors = runner.run();
        try {
            ListIterator<Tensor> resultTensorIter = resultTensors.listIterator();
            HashMap<String, Tensor> returnMap = new HashMap<String, Tensor>();
            for (String nodeName : outputToNode.keySet()) {
                returnMap.put(nodeName, resultTensorIter.next());
            }
            return returnMap;
        }
        catch (Exception e) {
            for (Tensor t2 : resultTensors) {
                t2.close();
            }
            throw e;
        }
    }

    public Tensor call(Tensor tensor) throws IllegalArgumentException {
        SignatureDef signatureDef = this.signature.asSignatureDef();
        if (signatureDef.getInputsCount() != 1) {
            throw new IllegalArgumentException(String.format("Function [%s] requires multiple inputs", signatureDef.getMethodName()));
        }
        String inputNodeName = signatureDef.getInputsMap().values().iterator().next().getName();
        if (signatureDef.getOutputsCount() != 1) {
            throw new IllegalArgumentException(String.format("Function [%s] has multiple outputs", signatureDef.getMethodName()));
        }
        String outputNodeName = signatureDef.getOutputsMap().values().iterator().next().getName();
        return this.session.runner().feed(inputNodeName, tensor).fetch(outputNodeName).run().get(0);
    }

    public void save(String exportDir) throws IOException {
        SavedModelBundle.exporter(exportDir).withFunction(this).export();
    }

    public Session session() {
        return this.session;
    }

    public Graph graph() {
        return this.graph;
    }

    @Override
    public void close() {
        if (this.ownership != Ownership.NONE) {
            this.session.close();
            if (this.ownership == Ownership.GRAPH_AND_SESSION) {
                this.graph.close();
            }
        }
    }

    public String toString() {
        return this.signature.toString();
    }

    ConcreteFunction(Signature signature, Graph graph, Session session, Ownership ownership) {
        this.graph = graph;
        this.session = session;
        this.signature = signature;
        this.ownership = ownership;
    }

    private static enum Ownership {
        GRAPH_AND_SESSION,
        SESSION_ONLY,
        NONE;

    }
}

