/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class TPUReplicatedOutput<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "TPUReplicatedOutput";
    private List<Output<T>> outputs;

    public static <T extends TType> TPUReplicatedOutput<T> create(Scope scope, Operand<T> input, Long numReplicas) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("num_replicas", numReplicas);
        return new TPUReplicatedOutput<T>(opBuilder.build());
    }

    public List<Output<T>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.outputs.iterator();
    }

    private TPUReplicatedOutput(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }
}

