/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.collective;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

public final class GatherV2<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "CollectiveGatherV2";
    private Output<T> data;

    public static <T extends TNumber> GatherV2<T> create(Scope scope, Operand<T> input, Operand<TInt32> groupSize, Operand<TInt32> groupKey, Operand<TInt32> instanceKey, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("GatherV2"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(groupSize.asOutput());
        opBuilder.addInput(groupKey.asOutput());
        opBuilder.addInput(instanceKey.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.communicationHint != null) {
                    opBuilder.setAttr("communication_hint", opts.communicationHint);
                }
                if (opts.timeoutSeconds == null) continue;
                opBuilder.setAttr("timeout_seconds", opts.timeoutSeconds.floatValue());
            }
        }
        return new GatherV2<T>(opBuilder.build());
    }

    public static Options communicationHint(String communicationHint) {
        return new Options().communicationHint(communicationHint);
    }

    public static Options timeoutSeconds(Float timeoutSeconds) {
        return new Options().timeoutSeconds(timeoutSeconds);
    }

    public Output<T> data() {
        return this.data;
    }

    @Override
    public Output<T> asOutput() {
        return this.data;
    }

    private GatherV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.data = operation.output(outputIdx++);
    }

    public static class Options {
        private String communicationHint;
        private Float timeoutSeconds;

        public Options communicationHint(String communicationHint) {
            this.communicationHint = communicationHint;
            return this;
        }

        public Options timeoutSeconds(Float timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        private Options() {
        }
    }
}

