/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.tensorflow.RawTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.layout.DataLayouts;
import org.tensorflow.ndarray.impl.dense.FloatDenseNdArray;
import org.tensorflow.types.TBfloat16;

public final class TBfloat16Mapper
extends TensorMapper<TBfloat16> {
    @Override
    protected TBfloat16 mapDense(RawTensor tensor) {
        DataBuffer buffer = DataLayouts.BFLOAT16.applyTo((DataBuffer)TensorBuffers.toShorts(TBfloat16Mapper.nativeHandle(tensor)));
        return new DenseTBfloat16(tensor, (FloatDataBuffer)buffer);
    }

    private static final class DenseTBfloat16
    extends FloatDenseNdArray
    implements TBfloat16 {
        final RawTensor rawTensor;

        public Class<TBfloat16> type() {
            return TBfloat16.class;
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTBfloat16(RawTensor rawTensor, FloatDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

