/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.c_api;

import com.google.protobuf.Message;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.tensorflow.internal.c_api.TF_Buffer;
import org.tensorflow.internal.c_api.presets.tensorflow;

@Properties(inherit={tensorflow.class})
public abstract class AbstractTF_Buffer
extends Pointer {
    public AbstractTF_Buffer(Pointer p) {
        super(p);
    }

    public static TF_Buffer newBuffer() {
        TF_Buffer b = org.tensorflow.internal.c_api.global.tensorflow.TF_NewBuffer();
        if (b != null) {
            b.deallocator(new DeleteDeallocator(b));
        }
        return b;
    }

    public static TF_Buffer newBufferFromString(Message proto) {
        if (proto == null) {
            return null;
        }
        return AbstractTF_Buffer.newBufferFromString((Pointer)new BytePointer(proto.toByteArray()));
    }

    public static TF_Buffer newBufferFromString(Pointer proto) {
        if (proto == null || proto.isNull() || proto.limit() == 0L) {
            return null;
        }
        TF_Buffer b = org.tensorflow.internal.c_api.global.tensorflow.TF_NewBufferFromString(proto, proto.limit());
        if (b != null) {
            b.deallocator(new DeleteDeallocator(b));
        }
        return b;
    }

    public byte[] copyData() {
        long length = ((TF_Buffer)this).length();
        if (length > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("TF_Buffer is too large to serialize into a byte[] array");
        }
        byte[] data = new byte[(int)length];
        new BytePointer(((TF_Buffer)this).data()).get(data);
        return data;
    }

    public ByteBuffer dataAsByteBuffer() {
        long length = ((TF_Buffer)this).length();
        if (length > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("TF_Buffer is too large to accessed via a ByteBuffer interface");
        }
        return ((TF_Buffer)this).data().capacity(length).asByteBuffer();
    }

    public void delete() {
        this.deallocate();
    }

    protected static class DeleteDeallocator
    extends TF_Buffer
    implements Pointer.Deallocator {
        DeleteDeallocator(TF_Buffer s) {
            super(s);
        }

        public void deallocate() {
            if (!this.isNull()) {
                org.tensorflow.internal.c_api.global.tensorflow.TF_DeleteBuffer(this);
            }
            this.setNull();
        }
    }
}

