/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Objects;
import org.bytedeco.javacpp.Pointer;
import org.tensorflow.AbstractOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.internal.types.registry.TensorTypeRegistry;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

public final class Output<T extends TType>
implements Operand<T> {
    private final AbstractOperation operation;
    private final int index;

    public int index() {
        return this.index;
    }

    public DataType dataType() {
        return this.operation.dtype(this.index);
    }

    @Override
    public Class<T> type() {
        return TensorTypeRegistry.find(this.dataType()).type();
    }

    public <U extends TType> Output<U> expect(Class<U> type) {
        if (type != this.type()) {
            throw new IllegalArgumentException("Cannot cast from output of " + this.type().getSimpleName() + " to output of " + type.getSimpleName());
        }
        return this;
    }

    @Override
    public T asTensor() {
        return (T)((TType)this.operation.tensor(this.index));
    }

    @Override
    public Shape shape() {
        return this.operation.shape(this.index);
    }

    @Override
    public Operation op() {
        return this.operation;
    }

    @Override
    public Output<T> asOutput() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.index);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Output) {
            Output that = (Output)o;
            return this.index == that.index && this.operation.equals(that.operation);
        }
        return false;
    }

    public String toString() {
        return String.format("<%s '%s:%d' shape=%s dtype=%s>", new Object[]{this.operation.type(), this.operation.name(), this.index, this.shape().toString(), this.dataType()});
    }

    Output(AbstractOperation op, int idx) {
        this.operation = op;
        this.index = idx;
    }

    Pointer getUnsafeNativeHandle() {
        return this.operation.getUnsafeNativeHandle(this.index);
    }
}

