/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class RestoreSlice<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RestoreSlice";
    private Output<T> tensor;

    public static <T extends TType> RestoreSlice<T> create(Scope scope, Operand<TString> filePattern, Operand<TString> tensorName, Operand<TString> shapeAndSlice, DataType<T> dt, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(filePattern.asOutput());
        opBuilder.addInput(tensorName.asOutput());
        opBuilder.addInput(shapeAndSlice.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dt", dt);
        if (options != null) {
            for (Options opts : options) {
                if (opts.preferredShard == null) continue;
                opBuilder.setAttr("preferred_shard", opts.preferredShard);
            }
        }
        return new RestoreSlice<T>(opBuilder.build());
    }

    public static Options preferredShard(Long preferredShard) {
        return new Options().preferredShard(preferredShard);
    }

    public Output<T> tensor() {
        return this.tensor;
    }

    @Override
    public Output<T> asOutput() {
        return this.tensor;
    }

    private RestoreSlice(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
    }

    public static class Options {
        private Long preferredShard;

        public Options preferredShard(Long preferredShard) {
            this.preferredShard = preferredShard;
            return this;
        }

        private Options() {
        }
    }
}

