/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;

public final class UnicodeTranscode
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "UnicodeTranscode";
    private Output<TString> output;

    public static UnicodeTranscode create(Scope scope, Operand<TString> input, String inputEncoding, String outputEncoding, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("input_encoding", inputEncoding);
        opBuilder.setAttr("output_encoding", outputEncoding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.errors != null) {
                    opBuilder.setAttr("errors", opts.errors);
                }
                if (opts.replacementChar != null) {
                    opBuilder.setAttr("replacement_char", opts.replacementChar);
                }
                if (opts.replaceControlCharacters == null) continue;
                opBuilder.setAttr("replace_control_characters", opts.replaceControlCharacters);
            }
        }
        return new UnicodeTranscode(opBuilder.build());
    }

    public static Options errors(String errors) {
        return new Options().errors(errors);
    }

    public static Options replacementChar(Long replacementChar) {
        return new Options().replacementChar(replacementChar);
    }

    public static Options replaceControlCharacters(Boolean replaceControlCharacters) {
        return new Options().replaceControlCharacters(replaceControlCharacters);
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    private UnicodeTranscode(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String errors;
        private Long replacementChar;
        private Boolean replaceControlCharacters;

        public Options errors(String errors) {
            this.errors = errors;
            return this;
        }

        public Options replacementChar(Long replacementChar) {
            this.replacementChar = replacementChar;
            return this;
        }

        public Options replaceControlCharacters(Boolean replaceControlCharacters) {
            this.replaceControlCharacters = replaceControlCharacters;
            return this;
        }

        private Options() {
        }
    }
}

