/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class ShuffleDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ShuffleDatasetV3";
    private Output<?> handle;

    public static ShuffleDataset create(Scope scope, Operand<?> inputDataset, Operand<TInt64> bufferSize, Operand<TInt64> seed, Operand<TInt64> seed2, Operand<?> seedGenerator, List<DataType<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("ShuffleDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(bufferSize.asOutput());
        opBuilder.addInput(seed.asOutput());
        opBuilder.addInput(seed2.asOutput());
        opBuilder.addInput(seedGenerator.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = outputTypes.get(i);
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.reshuffleEachIteration == null) continue;
                opBuilder.setAttr("reshuffle_each_iteration", opts.reshuffleEachIteration);
            }
        }
        return new ShuffleDataset(opBuilder.build());
    }

    public static Options reshuffleEachIteration(Boolean reshuffleEachIteration) {
        return new Options().reshuffleEachIteration(reshuffleEachIteration);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private ShuffleDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean reshuffleEachIteration;

        public Options reshuffleEachIteration(Boolean reshuffleEachIteration) {
            this.reshuffleEachIteration = reshuffleEachIteration;
            return this;
        }

        private Options() {
        }
    }
}

