/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class SplitV<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "SplitV";
    private List<Output<T>> output;

    public static <T extends TType, U extends TNumber> SplitV<T> create(Scope scope, Operand<T> value, Operand<U> sizeSplits, Operand<TInt32> axis, Long numSplit) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(value.asOutput());
        opBuilder.addInput(sizeSplits.asOutput());
        opBuilder.addInput(axis.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_split", numSplit);
        return new SplitV<T>(opBuilder.build());
    }

    public List<Output<T>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    private SplitV(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }
}

