/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class Enter<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Enter";
    private Output<T> output;

    public static <T extends TType> Enter<T> create(Scope scope, Operand<T> data, String frameName, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(data.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("frame_name", frameName);
        if (options != null) {
            for (Options opts : options) {
                if (opts.isConstant != null) {
                    opBuilder.setAttr("is_constant", opts.isConstant);
                }
                if (opts.parallelIterations == null) continue;
                opBuilder.setAttr("parallel_iterations", opts.parallelIterations);
            }
        }
        return new Enter<T>(opBuilder.build());
    }

    public static Options isConstant(Boolean isConstant) {
        return new Options().isConstant(isConstant);
    }

    public static Options parallelIterations(Long parallelIterations) {
        return new Options().parallelIterations(parallelIterations);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Enter(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean isConstant;
        private Long parallelIterations;

        public Options isConstant(Boolean isConstant) {
            this.isConstant = isConstant;
            return this;
        }

        public Options parallelIterations(Long parallelIterations) {
            this.parallelIterations = parallelIterations;
            return this;
        }

        private Options() {
        }
    }
}

