/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.c_api.presets;

import java.util.List;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.LoadEnabled;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.annotation.NoException;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;

@Properties(value={@Platform(value={"linux", "macosx", "windows"}, compiler={"cpp11"}, include={"tensorflow/core/util/port.h", "tensorflow/c/tf_attrtype.h", "tensorflow/c/tf_datatype.h", "tensorflow/c/tf_status.h", "tensorflow/c/tf_tensor.h", "tensorflow/c/c_api.h", "tensorflow/c/kernels.h", "tensorflow/c/ops.h", "tensorflow/c/eager/c_api.h"}, link={"tensorflow_cc@.2"}, preload={"iomp5", "mklml", "mklml_intel", "tensorflow_framework@.2"}, preloadresource={"/org/bytedeco/mkldnn/"}, resource={"LICENSE", "THIRD_PARTY_TF_JNI_LICENSES"}), @Platform(value={"windows"}, preload={"api-ms-win-crt-locale-l1-1-0", "api-ms-win-crt-string-l1-1-0", "api-ms-win-crt-stdio-l1-1-0", "api-ms-win-crt-math-l1-1-0", "api-ms-win-crt-heap-l1-1-0", "api-ms-win-crt-runtime-l1-1-0", "api-ms-win-crt-convert-l1-1-0", "api-ms-win-crt-environment-l1-1-0", "api-ms-win-crt-time-l1-1-0", "api-ms-win-crt-filesystem-l1-1-0", "api-ms-win-crt-utility-l1-1-0", "api-ms-win-crt-multibyte-l1-1-0", "api-ms-win-core-string-l1-1-0", "api-ms-win-core-errorhandling-l1-1-0", "api-ms-win-core-timezone-l1-1-0", "api-ms-win-core-file-l1-1-0", "api-ms-win-core-namedpipe-l1-1-0", "api-ms-win-core-handle-l1-1-0", "api-ms-win-core-file-l2-1-0", "api-ms-win-core-heap-l1-1-0", "api-ms-win-core-libraryloader-l1-1-0", "api-ms-win-core-synch-l1-1-0", "api-ms-win-core-processthreads-l1-1-0", "api-ms-win-core-processenvironment-l1-1-0", "api-ms-win-core-datetime-l1-1-0", "api-ms-win-core-localization-l1-2-0", "api-ms-win-core-sysinfo-l1-1-0", "api-ms-win-core-synch-l1-2-0", "api-ms-win-core-console-l1-1-0", "api-ms-win-core-debug-l1-1-0", "api-ms-win-core-rtlsupport-l1-1-0", "api-ms-win-core-processthreads-l1-1-1", "api-ms-win-core-file-l1-2-0", "api-ms-win-core-profile-l1-1-0", "api-ms-win-core-memory-l1-1-0", "api-ms-win-core-util-l1-1-0", "api-ms-win-core-interlocked-l1-1-0", "ucrtbase", "vcruntime140", "vcruntime140_1", "msvcp140", "concrt140", "vcomp140", "msvcr120", "libiomp5md", "mklml", "tensorflow_framework"}), @Platform(value={"windows-x86"}, preloadpath={"C:/Program Files (x86)/Microsoft Visual Studio 14.0/VC/redist/x86/Microsoft.VC140.CRT/", "C:/Program Files (x86)/Microsoft Visual Studio 14.0/VC/redist/x86/Microsoft.VC140.OpenMP/", "C:/Program Files (x86)/Windows Kits/10/Redist/ucrt/DLLs/x86/"}), @Platform(value={"windows-x86_64"}, preloadpath={"C:/Program Files (x86)/Microsoft Visual Studio 14.0/VC/redist/x64/Microsoft.VC140.CRT/", "C:/Program Files (x86)/Microsoft Visual Studio 14.0/VC/redist/x64/Microsoft.VC140.OpenMP/", "C:/Program Files (x86)/Windows Kits/10/Redist/ucrt/DLLs/x64/"}), @Platform(value={"linux", "macosx", "windows"}, extension={"-mkl", "-gpu", "-mkl-gpu"})}, target="org.tensorflow.internal.c_api", global="org.tensorflow.internal.c_api.global.tensorflow")
@NoException
public class tensorflow
implements LoadEnabled,
InfoMapper {
    public void init(ClassProperties properties) {
        String[] libs;
        String platform = properties.getProperty("platform");
        String extension = properties.getProperty("platform.extension");
        List preloads = properties.get("platform.preload");
        List resources = properties.get("platform.preloadresource");
        List preloadpaths = properties.get("platform.preloadpath");
        String vcredistdir = System.getenv("VCToolsRedistDir");
        if (vcredistdir != null && vcredistdir.length() > 0) {
            switch (platform) {
                case "windows-x86": {
                    preloadpaths.add(0, vcredistdir + "\\x86\\Microsoft.VC142.CRT");
                    preloadpaths.add(1, vcredistdir + "\\x86\\Microsoft.VC142.OpenMP");
                    preloadpaths.add(2, vcredistdir + "\\x86\\Microsoft.VC141.CRT");
                    preloadpaths.add(3, vcredistdir + "\\x86\\Microsoft.VC141.OpenMP");
                    break;
                }
                case "windows-x86_64": {
                    preloadpaths.add(0, vcredistdir + "\\x64\\Microsoft.VC142.CRT");
                    preloadpaths.add(1, vcredistdir + "\\x64\\Microsoft.VC142.OpenMP");
                    preloadpaths.add(2, vcredistdir + "\\x64\\Microsoft.VC141.CRT");
                    preloadpaths.add(3, vcredistdir + "\\x64\\Microsoft.VC141.OpenMP");
                    break;
                }
            }
        }
        if (!Loader.isLoadLibraries()) {
            return;
        }
        String load = System.getProperty("org.bytedeco.openblas.load", System.getProperty("org.bytedeco.mklml.load", "")).toLowerCase();
        int i = 0;
        if (load.equals("mkl") || load.equals("mkl_rt")) {
            libs = new String[]{"iomp5", "libiomp5md", "mkl_core", "mkl_avx", "mkl_avx2", "mkl_avx512", "mkl_avx512_mic", "mkl_def", "mkl_mc", "mkl_mc3", "mkl_intel_lp64", "mkl_intel_thread", "mkl_gnu_thread", "mkl_rt"};
            for (i = 0; i < libs.length; ++i) {
                preloads.add(i, libs[i] + "#" + libs[i]);
            }
            load = "mkl_rt";
            resources.add("/org/bytedeco/mkl/");
        }
        if (load.length() > 0) {
            if (platform.startsWith("linux")) {
                preloads.add(i, load + "#mklml_intel");
            } else if (platform.startsWith("macosx")) {
                preloads.add(i, load + "#mklml");
            } else if (platform.startsWith("windows")) {
                preloads.add(i, load + "#mklml");
            }
        }
        if (!Loader.isLoadLibraries() || extension == null || !extension.endsWith("-gpu")) {
            return;
        }
        block20: for (String lib : libs = new String[]{"cudart", "cublasLt", "cublas", "cufft", "curand", "cusolver", "cusparse", "cudnn", "nccl", "nvinfer"}) {
            switch (platform) {
                case "linux-arm64": 
                case "linux-ppc64le": 
                case "linux-x86_64": 
                case "macosx-x86_64": {
                    lib = lib + (lib.equals("cudnn") ? "@.7" : (lib.equals("nccl") ? "@.2" : (lib.equals("nvinfer") ? "@.6" : (lib.equals("cudart") ? "@.10.1" : "@.10"))));
                    break;
                }
                case "windows-x86_64": {
                    lib = lib + (lib.equals("cudnn") ? "64_7" : (lib.equals("cudart") ? "64_101" : "64_10"));
                    break;
                }
                default: {
                    continue block20;
                }
            }
            if (preloads.contains(lib)) continue;
            preloads.add(i++, lib);
        }
        if (i > 0) {
            resources.add("/org/bytedeco/cuda/");
            resources.add("/org/bytedeco/tensorrt/");
        }
    }

    public void map(InfoMap infoMap) {
        infoMap.put(new Info(new String[]{"TF_CAPI_EXPORT"}).cppTypes(new String[0]).annotations(new String[0])).put(new Info(new String[]{"TF_Buffer::data"}).javaText("public native @Const Pointer data(); public native TF_Buffer data(Pointer data);")).put(new Info(new String[]{"TF_Status"}).pointerTypes(new String[]{"TF_Status"}).base("org.tensorflow.internal.c_api.AbstractTF_Status")).put(new Info(new String[]{"TF_Buffer"}).pointerTypes(new String[]{"TF_Buffer"}).base("org.tensorflow.internal.c_api.AbstractTF_Buffer")).put(new Info(new String[]{"TF_Tensor"}).pointerTypes(new String[]{"TF_Tensor"}).base("org.tensorflow.internal.c_api.AbstractTF_Tensor")).put(new Info(new String[]{"TF_Session"}).pointerTypes(new String[]{"TF_Session"}).base("org.tensorflow.internal.c_api.AbstractTF_Session")).put(new Info(new String[]{"TF_SessionOptions"}).pointerTypes(new String[]{"TF_SessionOptions"}).base("org.tensorflow.internal.c_api.AbstractTF_SessionOptions")).put(new Info(new String[]{"TF_Graph"}).pointerTypes(new String[]{"TF_Graph"}).base("org.tensorflow.internal.c_api.AbstractTF_Graph")).put(new Info(new String[]{"TF_Graph::graph"}).javaText("public native @MemberGetter @ByRef Graph graph();")).put(new Info(new String[]{"TF_Graph::refiner"}).javaText("public native @MemberGetter @ByRef ShapeRefiner refiner();")).put(new Info(new String[]{"TF_ImportGraphDefOptions"}).pointerTypes(new String[]{"TF_ImportGraphDefOptions"}).base("org.tensorflow.internal.c_api.AbstractTF_ImportGraphDefOptions")).put(new Info(new String[]{"TF_Operation", "TF_WhileParams", "TFE_MonitoringCounterCell", "TFE_MonitoringSamplerCell", "TFE_MonitoringCounter0", "TFE_MonitoringCounter1", "TFE_MonitoringCounter2", "TFE_MonitoringIntGaugeCell", "TFE_MonitoringStringGaugeCell", "TFE_MonitoringBoolGaugeCell", "TFE_MonitoringIntGauge0", "TFE_MonitoringIntGauge1", "TFE_MonitoringIntGauge2", "TFE_MonitoringStringGauge0", "TFE_MonitoringStringGauge1", "TFE_MonitoringStringGauge2", "TFE_MonitoringBoolGauge0", "TFE_MonitoringBoolGauge1", "TFE_MonitoringBoolGauge2", "TFE_MonitoringSampler0", "TFE_MonitoringSampler1", "TFE_MonitoringSampler2"}).purify()).put(new Info(new String[]{"TF_Operation::node"}).javaText("public native @MemberGetter @ByRef Node node();")).put(new Info(new String[]{"TFE_MonitoringCounterCell::cell"}).javaText("public native @MemberGetter @ByRef CounterCell cell();")).put(new Info(new String[]{"TFE_MonitoringSamplerCell::cell"}).javaText("public native @MemberGetter @ByRef SamplerCell cell();")).put(new Info(new String[]{"TFE_MonitoringIntGaugeCell::cell"}).javaText("public native @MemberGetter @ByRef IntGaugeCell cell();")).put(new Info(new String[]{"TFE_MonitoringStringGaugeCell::cell"}).javaText("public native @MemberGetter @ByRef StringGaugeCell cell();")).put(new Info(new String[]{"TFE_MonitoringBoolGaugeCell::cell"}).javaText("public native @MemberGetter @ByRef BoolGaugeCell cell();")).put(new Info(new String[]{"TFE_Context"}).pointerTypes(new String[]{"TFE_Context"}).base("org.tensorflow.internal.c_api.AbstractTFE_Context")).put(new Info(new String[]{"TFE_ContextOptions"}).pointerTypes(new String[]{"TFE_ContextOptions"}).base("org.tensorflow.internal.c_api.AbstractTFE_ContextOptions")).put(new Info(new String[]{"TFE_Context::context"}).javaText("@MemberGetter public native @ByRef EagerContext context();")).put(new Info(new String[]{"TFE_Op"}).pointerTypes(new String[]{"TFE_Op"}).base("org.tensorflow.internal.c_api.AbstractTFE_Op")).put(new Info(new String[]{"TFE_Op::operation"}).javaText("@MemberGetter public native @ByRef EagerOperation operation();")).put(new Info(new String[]{"TFE_TensorHandle"}).pointerTypes(new String[]{"TFE_TensorHandle"}).base("org.tensorflow.internal.c_api.AbstractTFE_TensorHandle")).put(new Info(new String[]{"TF_ShapeInferenceContextDimValueKnown", "TFE_NewTensorHandle(const tensorflow::Tensor&, TF_Status*)"}).skip());
    }
}

