/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.AbstractOperation;
import org.tensorflow.DataType;
import org.tensorflow.DataTypes;
import org.tensorflow.Graph;
import org.tensorflow.Tensor;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_Operation;
import org.tensorflow.internal.c_api.TF_Output;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.ndarray.Shape;

public final class GraphOperation
extends AbstractOperation {
    private final Graph graph;
    private final TF_Operation unsafeNativeHandle;

    GraphOperation(Graph g, TF_Operation unsafeNativeHandle) {
        this.graph = g;
        this.unsafeNativeHandle = unsafeNativeHandle;
    }

    @Override
    public String name() {
        try (Graph.Reference r = this.graph.ref();){
            String string = GraphOperation.name(this.getUnsafeNativeHandle());
            return string;
        }
    }

    @Override
    public String type() {
        try (Graph.Reference r = this.graph.ref();){
            String string = GraphOperation.type(this.getUnsafeNativeHandle());
            return string;
        }
    }

    @Override
    public int numOutputs() {
        try (Graph.Reference r = this.graph.ref();){
            int n = GraphOperation.numOutputs(this.getUnsafeNativeHandle());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int outputListLength(String name) {
        try (Graph.Reference r = this.graph.ref();){
            int n = GraphOperation.outputListLength(this.getUnsafeNativeHandle(), name);
            return n;
        }
    }

    public int hashCode() {
        return Long.valueOf(this.getUnsafeNativeHandle().address()).hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphOperation)) {
            return false;
        }
        GraphOperation that = (GraphOperation)o;
        if (this.graph != that.graph) {
            return false;
        }
        try (Graph.Reference r = this.graph.ref();){
            boolean bl = this.getUnsafeNativeHandle().equals((Object)that.getUnsafeNativeHandle());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int inputListLength(String name) {
        try (Graph.Reference r = this.graph.ref();){
            int n = GraphOperation.inputListLength(this.getUnsafeNativeHandle(), name);
            return n;
        }
    }

    @Override
    TF_Operation getUnsafeNativeHandle(int outputIdx) {
        return this.getUnsafeNativeHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Shape shape(int outputIdx) {
        try (Graph.Reference r = this.graph.ref();){
            long[] shape = GraphOperation.shape(r.nativeHandle(), this.getUnsafeNativeHandle(), outputIdx);
            Shape shape2 = shape == null ? Shape.unknown() : Shape.of(shape);
            return shape2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DataType<?> dtype(int outputIdx) {
        try (Graph.Reference r = this.graph.ref();){
            DataType<?> dataType = DataTypes.fromNativeCode(GraphOperation.dtype(r.nativeHandle(), this.getUnsafeNativeHandle(), outputIdx));
            return dataType;
        }
    }

    @Override
    Tensor<?> tensor(int outputIdx) {
        throw new IllegalStateException("Graph tensors must be fetched by running a session");
    }

    TF_Operation getUnsafeNativeHandle() {
        return this.unsafeNativeHandle;
    }

    private static void requireHandle(Pointer handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("close() has been called on the Graph this Operation was a part of");
        }
    }

    private static String name(TF_Operation handle) {
        GraphOperation.requireHandle(handle);
        return tensorflow.TF_OperationName(handle).getString();
    }

    private static String type(TF_Operation handle) {
        GraphOperation.requireHandle(handle);
        return tensorflow.TF_OperationOpType(handle).getString();
    }

    private static int numOutputs(TF_Operation handle) {
        GraphOperation.requireHandle(handle);
        return tensorflow.TF_OperationNumOutputs(handle);
    }

    private static int outputListLength(TF_Operation handle, String name) {
        GraphOperation.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            int result = tensorflow.TF_OperationOutputListLength(handle, name, status);
            status.throwExceptionIfNotOK();
            int n = result;
            return n;
        }
    }

    private static int inputListLength(TF_Operation handle, String name) {
        GraphOperation.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            int result = tensorflow.TF_OperationInputListLength(handle, name, status);
            status.throwExceptionIfNotOK();
            int n = result;
            return n;
        }
    }

    private static long[] shape(TF_Graph graphHandle, TF_Operation opHandle, int outputIndex) {
        GraphOperation.requireHandle(graphHandle);
        GraphOperation.requireHandle(opHandle);
        int numOutputs = tensorflow.TF_OperationNumOutputs(opHandle);
        if (outputIndex < 0 || outputIndex >= numOutputs) {
            throw new IndexOutOfBoundsException("invalid output index (" + outputIndex + ") for an operation that has " + numOutputs + " outputs");
        }
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Output output = new TF_Output().oper(opHandle).index(outputIndex);
            TF_Status status = TF_Status.newStatus();
            int numDims = tensorflow.TF_GraphGetTensorNumDims(graphHandle, output, status);
            status.throwExceptionIfNotOK();
            if (numDims < 0) {
                long[] lArray = null;
                return lArray;
            }
            long[] dims = new long[numDims];
            tensorflow.TF_GraphGetTensorShape(graphHandle, output, dims, numDims, status);
            status.throwExceptionIfNotOK();
            long[] lArray = dims;
            return lArray;
        }
    }

    private static int dtype(TF_Graph graphHandle, TF_Operation opHandle, int outputIndex) {
        GraphOperation.requireHandle(graphHandle);
        GraphOperation.requireHandle(opHandle);
        int numOutputs = tensorflow.TF_OperationNumOutputs(opHandle);
        if (outputIndex < 0 || outputIndex >= numOutputs) {
            throw new IndexOutOfBoundsException("invalid output index (" + outputIndex + ") for an operation that has " + numOutputs + " outputs");
        }
        try (PointerScope scope = new PointerScope(new Class[0]);){
            int n = tensorflow.TF_OperationOutputType(new TF_Output().oper(opHandle).index(outputIndex));
            return n;
        }
    }
}

