/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.Device;
import ai.djl.engine.Engine;
import ai.djl.engine.EngineException;
import ai.djl.ndarray.BaseNDManager;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.onnxruntime.engine.OrtEngine;
import ai.djl.onnxruntime.engine.OrtNDArray;
import ai.djl.onnxruntime.engine.OrtUtils;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class OrtNDManager
extends BaseNDManager {
    private static final OrtNDManager SYSTEM_MANAGER = new SystemManager();
    private OrtEnvironment env;

    private OrtNDManager(NDManager parent, Device device, OrtEnvironment env) {
        super(parent, device);
        this.env = env;
    }

    static OrtNDManager getSystemManager() {
        return SYSTEM_MANAGER;
    }

    public ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    public OrtNDArray from(NDArray array) {
        if (array == null || array instanceof OrtNDArray) {
            return (OrtNDArray)array;
        }
        return this.create(array.toByteBuffer(), array.getShape(), array.getDataType());
    }

    OrtNDArray createInternal(OnnxTensor tensor) {
        return new OrtNDArray(this, this.alternativeManager, tensor);
    }

    public OrtNDArray create(Buffer data, Shape shape, DataType dataType) {
        if (dataType == DataType.STRING) {
            throw new IllegalArgumentException("Use NDManager.create(String[], Shape) to create String NDArray.");
        }
        int size = Math.toIntExact(shape.size());
        BaseNDManager.validateBuffer((Buffer)data, (DataType)dataType, (int)size);
        OnnxTensor tensor = OrtUtils.toTensor(this.env, data, shape, dataType);
        return new OrtNDArray(this, this.alternativeManager, tensor);
    }

    public NDArray create(String data) {
        return this.create(new String[]{data});
    }

    public NDArray create(String[] data) {
        return this.create(data, new Shape(new long[]{data.length}));
    }

    public NDArray create(String[] data, Charset charset, Shape shape) {
        try {
            return new OrtNDArray(this, this.alternativeManager, OrtUtils.toTensor(this.env, data, shape));
        }
        catch (OrtException e) {
            throw new EngineException((Throwable)e);
        }
    }

    public OrtNDManager newSubManager(Device device) {
        OrtNDManager manager = new OrtNDManager((NDManager)this, device, this.env);
        this.attachInternal(manager.uid, (AutoCloseable)((Object)manager));
        return manager;
    }

    public final Engine getEngine() {
        return Engine.getEngine((String)"OnnxRuntime");
    }

    public void close() {
        super.close();
        if (this.alternativeManager != null) {
            this.alternativeManager.close();
            this.alternativeManager = null;
        }
    }

    private static final class SystemManager
    extends OrtNDManager
    implements NDManager.SystemNDManager {
        SystemManager() {
            super(null, null, ((OrtEngine)Engine.getEngine((String)"OnnxRuntime")).getEnv());
        }

        @Override
        public void close() {
        }
    }
}

