/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.Device;
import ai.djl.engine.Engine;
import ai.djl.engine.EngineException;
import ai.djl.ndarray.BaseNDManager;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.onnxruntime.engine.OrtNDArray;
import ai.djl.onnxruntime.engine.OrtUtils;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OrtNDManager
extends BaseNDManager {
    private static final OrtNDManager SYSTEM_MANAGER = new SystemManager();
    private OrtEnvironment env;

    private OrtNDManager(NDManager parent, Device device, OrtEnvironment env) {
        super(parent, device);
        this.env = env;
    }

    static OrtNDManager getSystemManager() {
        return SYSTEM_MANAGER;
    }

    public ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    OrtNDArray create(OnnxTensor tensor) {
        return new OrtNDArray(this, tensor);
    }

    public OrtNDArray create(Buffer data, Shape shape, DataType dataType) {
        try {
            return new OrtNDArray(this, OrtUtils.toTensor(this.env, data, shape, dataType));
        }
        catch (OrtException e) {
            throw new EngineException((Throwable)e);
        }
    }

    public NDArray create(String data) {
        return this.create(new String[]{data}, new Shape(new long[]{1L}));
    }

    public NDArray create(String[] data) {
        return this.create(data, new Shape(new long[]{data.length}));
    }

    public NDArray create(String[] data, Shape shape) {
        try {
            return new OrtNDArray(this, OrtUtils.toTensor(this.env, data, shape));
        }
        catch (OrtException e) {
            throw new EngineException((Throwable)e);
        }
    }

    public NDArray zeros(Shape shape, DataType dataType) {
        int bytes = dataType.getNumOfBytes();
        int size = Math.toIntExact((long)bytes * shape.size());
        ByteBuffer buffer = this.allocateDirect(size);
        return this.create(dataType.asDataType(buffer), shape, dataType);
    }

    public NDArray ones(Shape shape, DataType dataType) {
        long size = shape.size();
        int bytes = Math.toIntExact((long)dataType.getNumOfBytes() * size);
        ByteBuffer buffer = this.allocateDirect(bytes);
        int i = 0;
        while ((long)i < size) {
            switch (dataType) {
                case BOOLEAN: 
                case INT8: 
                case UINT8: {
                    buffer.put((byte)1);
                    break;
                }
                case FLOAT32: {
                    buffer.putFloat(1.0f);
                    break;
                }
                case FLOAT64: {
                    buffer.putDouble(1.0);
                    break;
                }
                case INT32: {
                    buffer.putInt(1);
                    break;
                }
                case INT64: {
                    buffer.putLong(1L);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported dataType: " + dataType);
                }
            }
            ++i;
        }
        buffer.rewind();
        return this.create(dataType.asDataType(buffer), shape, dataType);
    }

    public OrtNDManager newSubManager(Device device) {
        OrtNDManager manager = new OrtNDManager((NDManager)this, device, this.env);
        this.attachInternal(manager.uid, (AutoCloseable)((Object)manager));
        return manager;
    }

    public final Engine getEngine() {
        return Engine.getEngine((String)"OnnxRuntime");
    }

    private static final class SystemManager
    extends OrtNDManager {
        SystemManager() {
            super(null, null, OrtEnvironment.getEnvironment());
        }

        public void attachInternal(String resourceId, AutoCloseable resource) {
        }

        public void detachInternal(String resourceId) {
        }

        public void close() {
        }
    }
}

