/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.onnxruntime.engine;

import ai.djl.Device;
import ai.djl.ndarray.NDArrayAdapter;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.onnxruntime.engine.OrtNDManager;
import ai.djl.onnxruntime.engine.OrtUtils;
import ai.onnxruntime.OnnxTensor;
import java.util.Arrays;
import java.util.UUID;

public class OrtNDArray
implements NDArrayAdapter {
    private OrtNDManager manager;
    private OnnxTensor tensor;
    private Shape shape;
    private DataType dataType;
    private String name;
    private boolean isClosed;
    private String uid;

    OrtNDArray(OrtNDManager manager, OnnxTensor tensor) {
        this.manager = manager;
        this.tensor = tensor;
        this.uid = UUID.randomUUID().toString();
        manager.attach(this.uid, (AutoCloseable)((Object)this));
    }

    OnnxTensor getTensor() {
        return this.tensor;
    }

    public NDManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUid() {
        return this.uid;
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = OrtUtils.toDataType(this.tensor.getInfo().type);
        }
        return this.dataType;
    }

    public Device getDevice() {
        return Device.cpu();
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = new Shape(this.tensor.getInfo().getShape());
        }
        return this.shape;
    }

    public NDManager attach(NDManager manager) {
        this.detach();
        OrtNDManager original = this.manager;
        this.manager = (OrtNDManager)manager;
        manager.attach(this.getUid(), (AutoCloseable)((Object)this));
        return original;
    }

    public void detach() {
        this.manager.detach(this.getUid());
        this.manager = OrtNDManager.getSystemManager();
    }

    public String toString() {
        if (this.isClosed) {
            return "This array is already closed";
        }
        return "ND: " + this.getShape() + ' ' + this.getDevice() + ' ' + this.getDataType() + '\n' + Arrays.toString(this.toArray());
    }

    public void close() {
        this.tensor.close();
        this.isClosed = true;
    }
}

