/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import ai.djl.mxnet.engine.MxNDArray;
import ai.djl.mxnet.engine.MxNDManager;
import ai.djl.mxnet.jna.JnaUtils;
import ai.djl.mxnet.jna.PointerArray;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.util.PairList;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.List;

public class FunctionInfo {
    private Pointer handle;
    private String name;
    private PairList<String, String> arguments;

    FunctionInfo(Pointer pointer, String functionName, PairList<String, String> arguments) {
        this.handle = pointer;
        this.name = functionName;
        this.arguments = arguments;
    }

    public int invoke(NDManager manager, NDArray[] src, NDArray[] dest, PairList<String, ?> params) {
        PointerArray srcHandles = JnaUtils.toPointerArray(src);
        PointerByReference destRef = new PointerByReference((Pointer)JnaUtils.toPointerArray(dest));
        return JnaUtils.imperativeInvoke(this.handle, srcHandles, destRef, params).size();
    }

    public NDArray[] invoke(NDManager manager, NDArray[] src, PairList<String, ?> params) {
        PointerArray srcHandles = JnaUtils.toPointerArray(src);
        return this.invoke((MxNDManager)manager, srcHandles, params);
    }

    private NDArray[] invoke(MxNDManager manager, PointerArray src, PairList<String, ?> params) {
        PointerByReference destRef = new PointerByReference();
        PairList<Pointer, SparseFormat> pairList = JnaUtils.imperativeInvoke(this.handle, src, destRef, params);
        return (NDArray[])pairList.stream().map(pair -> {
            if (pair.getValue() != SparseFormat.DENSE) {
                return manager.create((Pointer)pair.getKey(), (SparseFormat)pair.getValue());
            }
            return manager.create((Pointer)pair.getKey());
        }).toArray(MxNDArray[]::new);
    }

    public String getFunctionName() {
        return this.name;
    }

    public List<String> getArgumentNames() {
        return this.arguments.keys();
    }

    public List<String> getArgumentTypes() {
        return this.arguments.values();
    }
}

