/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.mxnet.engine.MxModel;
import ai.djl.mxnet.engine.MxNDManager;
import ai.djl.mxnet.jna.JnaUtils;
import ai.djl.ndarray.NDManager;
import java.lang.management.MemoryUsage;

public class MxEngine
extends Engine {
    public static final String ENGINE_NAME = "MXNet";

    MxEngine() {
        JnaUtils.getAllOpNames();
        JnaUtils.setNumpyMode(JnaUtils.NumpyMode.GLOBAL_ON);
        Runtime.getRuntime().addShutdownHook(new Thread(JnaUtils::waitAll));
    }

    public String getEngineName() {
        return ENGINE_NAME;
    }

    public int getGpuCount() {
        return JnaUtils.getGpuCount();
    }

    public MemoryUsage getGpuMemory(Device device) {
        long[] mem = JnaUtils.getGpuMemory(device);
        long committed = mem[1] - mem[0];
        return new MemoryUsage(-1L, committed, committed, mem[1]);
    }

    public Device defaultDevice() {
        if (this.getGpuCount() > 0) {
            return Device.gpu();
        }
        return Device.cpu();
    }

    public String getVersion() {
        int version = JnaUtils.getVersion();
        int major = version / 10000;
        int minor = version / 100 - major * 100;
        int patch = version % 100;
        return major + "." + minor + '.' + patch;
    }

    public Model newModel(Device device) {
        return new MxModel(device);
    }

    public NDManager newBaseManager() {
        return MxNDManager.getSystemManager().newSubManager();
    }

    public NDManager newBaseManager(Device device) {
        return MxNDManager.getSystemManager().newSubManager();
    }
}

