/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.FillMaskTranslator;
import ai.djl.modality.Classifications;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.TranslatorContext;

public class FillMaskBatchTranslator
implements NoBatchifyTranslator<String[], Classifications[]> {
    private HuggingFaceTokenizer tokenizer;
    private String maskToken;
    private long maskTokenId;
    private int topK;
    private boolean includeTokenTypes;
    private Batchifier batchifier;

    FillMaskBatchTranslator(HuggingFaceTokenizer tokenizer, String maskToken, int topK, boolean includeTokenTypes, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.maskToken = maskToken;
        this.topK = topK;
        this.includeTokenTypes = includeTokenTypes;
        this.batchifier = batchifier;
        Encoding encoding = tokenizer.encode(maskToken, false, false);
        this.maskTokenId = encoding.getIds()[0];
    }

    public NDList processInput(TranslatorContext ctx, String[] inputs) throws TranslateException {
        NDManager manager = ctx.getNDManager();
        Encoding[] encodings = this.tokenizer.batchEncode(inputs);
        NDList[] batch = new NDList[encodings.length];
        int[] maskIndices = new int[encodings.length];
        ctx.setAttachment("maskIndices", (Object)maskIndices);
        for (int i = 0; i < encodings.length; ++i) {
            long[] indices = encodings[i].getIds();
            maskIndices[i] = FillMaskTranslator.getMaskIndex(indices, this.maskToken, this.maskTokenId);
            batch[i] = encodings[i].toNDList(manager, this.includeTokenTypes);
        }
        return this.batchifier.batchify(batch);
    }

    public Classifications[] processOutput(TranslatorContext ctx, NDList list) {
        NDList[] batch = this.batchifier.unbatchify(list);
        int[] maskIndices = (int[])ctx.getAttachment("maskIndices");
        Classifications[] ret = new Classifications[maskIndices.length];
        for (int i = 0; i < batch.length; ++i) {
            ret[i] = FillMaskTranslator.toClassifications(this.tokenizer, batch[i], maskIndices[i], this.topK);
        }
        return ret;
    }
}

