/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.tokenizers;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.jni.CharSpan;
import ai.djl.huggingface.tokenizers.jni.LibUtils;
import ai.djl.huggingface.tokenizers.jni.TokenizersLibrary;
import ai.djl.modality.nlp.preprocess.Tokenizer;
import ai.djl.util.NativeResource;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class HuggingFaceTokenizer
extends NativeResource<Long>
implements Tokenizer {
    private boolean addSpecialTokens;

    private HuggingFaceTokenizer(long handle, boolean addSpecialTokens) {
        super((Object)handle);
        this.addSpecialTokens = addSpecialTokens;
    }

    public static HuggingFaceTokenizer newInstance(String name) {
        return HuggingFaceTokenizer.newInstance(name, null);
    }

    public static HuggingFaceTokenizer newInstance(String identifier, Map<String, String> options) {
        LibUtils.checkStatus();
        long handle = TokenizersLibrary.LIB.createTokenizer(identifier);
        boolean addSpecialTokens = options == null || !options.containsKey("addSpecialTokens") || Boolean.parseBoolean(options.get("addSpecialTokens"));
        return new HuggingFaceTokenizer(handle, addSpecialTokens);
    }

    public static HuggingFaceTokenizer newInstance(Path modelPath) throws IOException {
        return HuggingFaceTokenizer.newInstance(modelPath, null);
    }

    public static HuggingFaceTokenizer newInstance(Path modelPath, Map<String, String> options) throws IOException {
        try (InputStream is = Files.newInputStream(modelPath, new OpenOption[0]);){
            HuggingFaceTokenizer huggingFaceTokenizer = HuggingFaceTokenizer.newInstance(is, options);
            return huggingFaceTokenizer;
        }
    }

    public static HuggingFaceTokenizer newInstance(InputStream is, Map<String, String> options) throws IOException {
        LibUtils.checkStatus();
        String json = Utils.toString((InputStream)is);
        long handle = TokenizersLibrary.LIB.createTokenizerFromString(json);
        boolean addSpecialTokens = options != null && Boolean.parseBoolean(options.get("addSpecialTokens"));
        return new HuggingFaceTokenizer(handle, addSpecialTokens);
    }

    public List<String> tokenize(String sentence) {
        Encoding encoding = this.encode(sentence);
        return Arrays.asList(encoding.getTokens());
    }

    public String buildSentence(List<String> tokens) {
        return String.join((CharSequence)" ", tokens);
    }

    public void close() {
        Long pointer = this.handle.getAndSet(null);
        if (pointer != null) {
            TokenizersLibrary.LIB.deleteTokenizer(pointer);
        }
    }

    public Encoding encode(String input) {
        long encoding = TokenizersLibrary.LIB.encode((Long)this.getHandle(), input, this.addSpecialTokens);
        return this.toEncoding(encoding);
    }

    public Encoding encode(List<String> inputs) {
        String[] array = inputs.toArray(new String[0]);
        return this.encode(array);
    }

    public Encoding encode(String[] inputs) {
        long encoding = TokenizersLibrary.LIB.encodeList((Long)this.getHandle(), inputs, this.addSpecialTokens);
        return this.toEncoding(encoding);
    }

    public Encoding[] batchEncode(List<String> inputs) {
        String[] array = inputs.toArray(new String[0]);
        return this.batchEncode(array);
    }

    public Encoding[] batchEncode(String[] inputs) {
        long[] encodings = TokenizersLibrary.LIB.batchEncode((Long)this.getHandle(), inputs, this.addSpecialTokens);
        Encoding[] ret = new Encoding[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            ret[i] = this.toEncoding(encodings[i]);
        }
        return ret;
    }

    private Encoding toEncoding(long encoding) {
        long[] ids = TokenizersLibrary.LIB.getTokenIds(encoding);
        long[] typeIds = TokenizersLibrary.LIB.getTypeIds(encoding);
        String[] tokens = TokenizersLibrary.LIB.getTokens(encoding);
        long[] wordIds = TokenizersLibrary.LIB.getWordIds(encoding);
        long[] attentionMask = TokenizersLibrary.LIB.getAttentionMask(encoding);
        long[] specialTokenMask = TokenizersLibrary.LIB.getSpecialTokenMask(encoding);
        CharSpan[] charSpans = TokenizersLibrary.LIB.getTokenCharSpans(encoding);
        TokenizersLibrary.LIB.deleteEncoding(encoding);
        return new Encoding(ids, typeIds, tokens, wordIds, attentionMask, specialTokenMask, charSpans);
    }
}

