/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.tokenizers.jni;

import ai.djl.engine.EngineException;
import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = System.mapLibraryName("tokenizers");
    private static EngineException exception;

    private LibUtils() {
    }

    public static void checkStatus() {
        if (exception != null) {
            throw exception;
        }
    }

    private static void loadLibrary() {
        String[] libs = System.getProperty("os.name").startsWith("Windows") ? new String[]{"libwinpthread-1.dll", "libgcc_s_seh-1.dll", "libstdc++-6.dll", LIB_NAME} : new String[]{LIB_NAME};
        Path dir = LibUtils.copyJniLibraryFromClasspath(libs);
        logger.debug("Loading huggingface library from: {}", (Object)dir);
        for (String libName : libs) {
            System.load(dir.resolve(libName).toString());
        }
    }

    private static Path copyJniLibraryFromClasspath(String[] libs) {
        Path path;
        block20: {
            Path cacheDir = Utils.getEngineCacheDir((String)"tokenizers");
            Platform platform = Platform.detectPlatform((String)"tokenizers");
            String classifier = platform.getClassifier();
            String version = platform.getVersion();
            Path dir = cacheDir.resolve(version + '-' + classifier);
            Path path2 = dir.resolve(LIB_NAME);
            logger.debug("Using cache dir: {}", (Object)dir);
            if (Files.exists(path2, new LinkOption[0])) {
                return dir.toAbsolutePath();
            }
            Path tmp = null;
            try {
                Files.createDirectories(cacheDir, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheDir, "tmp", new FileAttribute[0]);
                for (String libName : libs) {
                    String libPath = "/native/lib/" + classifier + "/" + libName;
                    logger.info("Extracting {} to cache ...", (Object)libPath);
                    try (InputStream is = LibUtils.class.getResourceAsStream(libPath);){
                        if (is == null) {
                            throw new IllegalStateException("tokenizers library not found: " + libPath);
                        }
                        Path target = tmp.resolve(libName);
                        Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                path = dir.toAbsolutePath();
                if (tmp == null) break block20;
            }
            catch (IOException iOException) {
                try {
                    throw new IllegalStateException("Cannot copy jni files", iOException);
                }
                catch (Throwable throwable) {
                    if (tmp != null) {
                        Utils.deleteQuietly(tmp);
                    }
                    throw throwable;
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return path;
    }

    static {
        try {
            LibUtils.loadLibrary();
        }
        catch (RuntimeException e) {
            exception = new EngineException("Failed to load Huggingface native library.", (Throwable)e);
        }
    }
}

