/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext.engine;

import ai.djl.Model;
import ai.djl.fasttext.engine.FtModel;
import ai.djl.inference.Predictor;
import ai.djl.metric.Metrics;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FtPredictor<I, O>
implements Predictor<I, O> {
    private FtModel model;
    private Translator<I, O> translator;

    FtPredictor(FtModel model, Translator<I, O> translator) {
        this.model = model;
        this.translator = translator;
    }

    public O predict(I input) throws TranslateException {
        try {
            FtPredictorContext ctx = new FtPredictorContext(this.model, input);
            return (O)this.translator.processOutput((TranslatorContext)ctx, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TranslateException((Throwable)e);
        }
    }

    public List<O> batchPredict(List<I> inputs) throws TranslateException {
        ArrayList<O> list = new ArrayList<O>(inputs.size());
        for (I input : inputs) {
            list.add(this.predict(input));
        }
        return list;
    }

    public void setMetrics(Metrics metrics) {
    }

    public void close() {
    }

    private static class FtPredictorContext
    implements TranslatorContext {
        private Model model;
        private Map<String, Object> attachments;

        FtPredictorContext(Model model, Object input) {
            this.model = model;
            this.attachments = new ConcurrentHashMap<String, Object>();
            this.attachments.put("input", input);
        }

        public Model getModel() {
            return this.model;
        }

        public NDManager getNDManager() {
            return null;
        }

        public Metrics getMetrics() {
            return null;
        }

        public Object getAttachment(String key) {
            return this.attachments.get(key);
        }

        public void setAttachment(String key, Object value) {
            this.attachments.put(key, value);
        }

        public void close() {
        }
    }
}

