/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext.jni;

import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "jni_fasttext";

    private LibUtils() {
    }

    public static void loadLibrary() {
        if (System.getProperty("os.name").startsWith("Win")) {
            throw new UnsupportedOperationException("Windows is not supported.");
        }
        String libName = LibUtils.copyJniLibraryFromClasspath();
        logger.debug("Loading fasttext library from: {}", (Object)libName);
        System.load(libName);
    }

    /*
     * Loose catch block
     */
    private static String copyJniLibraryFromClasspath() {
        String string;
        InputStream stream;
        Path tmp;
        block14: {
            block13: {
                String name = System.mapLibraryName(LIB_NAME);
                Path nativeDir = Utils.getEngineCacheDir((String)"fasttext");
                Platform platform = Platform.detectPlatform((String)"fasttext");
                String classifier = platform.getClassifier();
                String version = platform.getVersion();
                Path path = nativeDir.resolve(version).resolve(name);
                if (Files.exists(path, new LinkOption[0])) {
                    return path.toAbsolutePath().toString();
                }
                tmp = null;
                String libPath = "/native/lib/" + classifier + "/" + name;
                stream = LibUtils.class.getResourceAsStream(libPath);
                if (stream == null) {
                    throw new IllegalStateException("fastText library not found: " + libPath);
                }
                Files.createDirectories(nativeDir.resolve(version), new FileAttribute[0]);
                tmp = Files.createTempFile(nativeDir, "jni", "tmp", new FileAttribute[0]);
                Files.copy(stream, tmp, StandardCopyOption.REPLACE_EXISTING);
                Utils.moveQuietly((Path)tmp, (Path)path);
                string = path.toAbsolutePath().toString();
                if (stream == null) break block13;
                stream.close();
            }
            if (tmp == null) break block14;
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot copy jni files", e);
                    }
                }
                catch (Throwable throwable3) {
                    if (tmp != null) {
                        Utils.deleteQuietly(tmp);
                    }
                    throw throwable3;
                }
            }
        }
    }
}

