/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.CocoMetadata;
import ai.djl.basicdataset.CocoUtils;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.Resource;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.training.dataset.Record;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CocoDetection
extends RandomAccessDataset {
    private static final String ARTIFACT_ID = "coco";
    private Dataset.Usage usage;
    private Image.Flag flag;
    private List<Path> imagePaths;
    private List<double[][]> labels;
    private Resource resource;
    private boolean prepared;

    CocoDetection(Builder builder) {
        super((RandomAccessDataset.BaseBuilder)builder);
        this.usage = builder.usage;
        this.flag = builder.flag;
        this.imagePaths = new ArrayList<Path>();
        this.labels = new ArrayList<double[][]>();
        MRL mrl = MRL.dataset((Application)Application.CV.ANY, (String)builder.groupId, (String)builder.artifactId);
        this.resource = new Resource(builder.repository, mrl, "1.0");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Record get(NDManager manager, long index) throws IOException {
        int idx = Math.toIntExact(index);
        NDList d = new NDList(new NDArray[]{ImageFactory.getInstance().fromFile(this.imagePaths.get(idx)).toNDArray(manager, this.flag)});
        NDList l = new NDList(new NDArray[]{manager.create(this.labels.get(idx))});
        return new Record(d, l);
    }

    public void prepare(Progress progress) throws IOException {
        Path jsonFile;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.resource.getDefaultArtifact();
        this.resource.prepare(artifact, progress);
        Path root = this.resource.getRepository().getResourceDirectory(artifact);
        switch (this.usage) {
            case TRAIN: {
                jsonFile = root.resolve("annotations").resolve("instances_train2017.json");
                break;
            }
            case TEST: {
                jsonFile = root.resolve("annotations").resolve("instances_val2017.json");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        CocoUtils coco = new CocoUtils(jsonFile);
        coco.prepare();
        List<Long> imageIds = coco.getImageIds();
        for (long id : imageIds) {
            Path imagePath = root.resolve(coco.getRelativeImagePath(id));
            List<double[]> labelOfImageId = this.getLabels(coco, id);
            if (labelOfImageId.isEmpty()) continue;
            this.imagePaths.add(imagePath);
            this.labels.add((double[][])labelOfImageId.toArray((T[])new double[0][]));
        }
        this.prepared = true;
    }

    protected long availableSize() {
        return this.imagePaths.size();
    }

    private List<double[]> getLabels(CocoUtils coco, long imageId) {
        List<Long> annotationIds = coco.getAnnotationIdByImageId(imageId);
        if (annotationIds == null) {
            return Collections.emptyList();
        }
        ArrayList<double[]> label = new ArrayList<double[]>();
        for (long annotationId : annotationIds) {
            CocoMetadata.Annotation annotation = coco.getAnnotationById(annotationId);
            if (!(annotation.getArea() > 0.0)) continue;
            double[] box = annotation.getBoundingBox();
            double[] list = new double[5];
            System.arraycopy(box, 0, list, 0, 4);
            list[4] = coco.mapCategoryId(annotation.getCategoryId());
            label.add(list);
        }
        return label;
    }

    public static final class Builder
    extends RandomAccessDataset.BaseBuilder<Builder> {
        Image.Flag flag;
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "coco";
        Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
            this.flag = Image.Flag.COLOR;
        }

        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this.self();
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this.self();
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optFlag(Image.Flag flag) {
            this.flag = flag;
            return this.self();
        }

        public CocoDetection build() {
            if (this.pipeline == null) {
                this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            }
            return new CocoDetection(this);
        }
    }
}

