/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.basicdataset.utils.TextData;
import ai.djl.engine.Engine;
import ai.djl.modality.nlp.SimpleVocabulary;
import ai.djl.modality.nlp.embedding.TextEmbedding;
import ai.djl.ndarray.NDManager;
import ai.djl.training.dataset.RandomAccessDataset;
import java.util.List;

public abstract class TextDataset
extends RandomAccessDataset {
    protected TextData sourceTextData;
    protected TextData targetTextData;
    protected NDManager manager;

    public TextDataset(Builder<?> builder) {
        super(builder);
        this.sourceTextData = new TextData(TextData.getDefaultConfiguration().update(((Builder)builder).sourceConfiguration));
        this.targetTextData = new TextData(TextData.getDefaultConfiguration().update(((Builder)builder).targetConfiguration));
        this.manager = ((Builder)builder).manager;
    }

    public TextEmbedding getTextEmbedding(boolean source) {
        TextData textData = source ? this.sourceTextData : this.targetTextData;
        return textData.getTextEmbedding();
    }

    public SimpleVocabulary getVocabulary(boolean source) {
        TextData textData = source ? this.sourceTextData : this.targetTextData;
        return textData.getVocabulary();
    }

    public String getRawText(long index, boolean source) {
        TextData textData = source ? this.sourceTextData : this.targetTextData;
        return textData.getRawText(index);
    }

    public List<String> getProcessedText(long index, boolean source) {
        TextData textData = source ? this.sourceTextData : this.targetTextData;
        return textData.getProcessedText(index);
    }

    protected void preprocess(List<String> newTextData, boolean source) {
        TextData textData = source ? this.sourceTextData : this.targetTextData;
        textData.preprocess(this.manager, newTextData.subList(0, (int)Math.min(this.limit, (long)newTextData.size())));
    }

    public static abstract class Builder<T extends Builder<T>>
    extends RandomAccessDataset.BaseBuilder<T> {
        private TextData.Configuration sourceConfiguration = new TextData.Configuration();
        private TextData.Configuration targetConfiguration = new TextData.Configuration();
        private NDManager manager = Engine.getInstance().newBaseManager();

        public T setSourceConfiguration(TextData.Configuration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return (T)((Object)((Builder)this.self()));
        }

        public T setTargetConfiguration(TextData.Configuration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return (T)((Object)((Builder)this.self()));
        }

        public T optManager(NDManager manager) {
            this.manager = manager.newSubManager();
            return (T)((Object)((Builder)this.self()));
        }
    }
}

