/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.CocoMetadata;
import ai.djl.basicdataset.CocoUtils;
import ai.djl.modality.cv.Rectangle;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.util.BufferedImageUtils;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.dataset.ZooDataset;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.training.dataset.Record;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CocoDetection
extends RandomAccessDataset
implements ZooDataset {
    private static final String ARTIFACT_ID = "coco";
    private Repository repository;
    private Artifact artifact;
    private Dataset.Usage usage;
    private boolean prepared;
    private NDImageUtils.Flag flag;
    private CocoUtils coco;
    private List<Path> imagePaths;
    private List<double[][]> labels;

    CocoDetection(Builder builder) {
        super((RandomAccessDataset.BaseBuilder)builder);
        this.repository = builder.repository;
        this.artifact = builder.artifact;
        this.usage = builder.usage;
        this.flag = builder.flag;
        this.imagePaths = new ArrayList<Path>();
        this.labels = new ArrayList<double[][]>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public MRL getMrl() {
        return MRL.dataset((Application)Application.CV.IMAGE_CLASSIFICATION, (String)"ai.djl.basicdataset", (String)ARTIFACT_ID);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Dataset.Usage getUsage() {
        return this.usage;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public void useDefaultArtifact() throws IOException {
        this.artifact = this.repository.resolve(this.getMrl(), "1.0", null);
    }

    public Record get(NDManager manager, long index) throws IOException {
        int idx = Math.toIntExact(index);
        NDList d = new NDList(new NDArray[]{BufferedImageUtils.readFileToArray((NDManager)manager, (Path)this.imagePaths.get(idx), (NDImageUtils.Flag)this.flag)});
        NDList l = new NDList(new NDArray[]{manager.create(this.labels.get(idx))});
        return new Record(d, l);
    }

    public void prepareData(Dataset.Usage usage) throws IOException {
        Path jsonFile;
        Path cacheDir = this.repository.getCacheDirectory();
        URI resourceUri = this.artifact.getResourceUri();
        Path root = cacheDir.resolve(resourceUri.getPath());
        switch (usage) {
            case TRAIN: {
                jsonFile = root.resolve("annotations").resolve("instances_train2017.json");
                break;
            }
            case TEST: {
                jsonFile = root.resolve("annotations").resolve("instances_val2017.json");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        this.coco = new CocoUtils(jsonFile);
        this.coco.prepare();
        List<Long> imageIds = this.coco.getImageIds();
        for (long id : imageIds) {
            Path imagePath = root.resolve(this.coco.getRelativeImagePath(id));
            List<double[]> labelOfImageId = this.getLabels(id);
            if (labelOfImageId.isEmpty()) continue;
            this.imagePaths.add(imagePath);
            this.labels.add((double[][])labelOfImageId.toArray((T[])new double[0][]));
        }
    }

    public long size() {
        return this.imagePaths.size();
    }

    private double[] convertRecToList(Rectangle rect) {
        double[] list = new double[5];
        list[0] = rect.getX();
        list[1] = rect.getY();
        list[2] = rect.getWidth();
        list[3] = rect.getHeight();
        return list;
    }

    private List<double[]> getLabels(long imageId) {
        List<Long> annotationIds = this.coco.getAnnotationIdByImageId(imageId);
        if (annotationIds == null) {
            return Collections.emptyList();
        }
        ArrayList<double[]> label = new ArrayList<double[]>();
        for (long annotationId : annotationIds) {
            CocoMetadata.Annotation annotation = this.coco.getAnnotationById(annotationId);
            Rectangle bBox = annotation.getBoundingBox();
            if (!(annotation.getArea() > 0.0)) continue;
            double[] list = this.convertRecToList(bBox);
            list[4] = this.coco.mapCategoryId(annotation.getCategoryId());
            label.add(list);
        }
        return label;
    }

    public static final class Builder
    extends RandomAccessDataset.BaseBuilder<Builder> {
        NDImageUtils.Flag flag;
        Repository repository = BasicDatasets.REPOSITORY;
        Artifact artifact;
        Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
            this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            this.flag = NDImageUtils.Flag.COLOR;
        }

        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this.self();
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this.self();
        }

        public Builder optArtifact(Artifact artifact) {
            this.artifact = artifact;
            return this.self();
        }

        public Builder optFlag(NDImageUtils.Flag flag) {
            this.flag = flag;
            return this.self();
        }

        public CocoDetection build() {
            return new CocoDetection(this);
        }
    }
}

