/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.tabular;

import ai.djl.basicdataset.tabular.utils.DynamicBuffer;
import ai.djl.basicdataset.tabular.utils.Feature;
import ai.djl.basicdataset.tabular.utils.Featurizers;
import ai.djl.basicdataset.tabular.utils.PreparedFeaturizer;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.Shape;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.training.dataset.Record;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class TabularDataset
extends RandomAccessDataset {
    protected List<Feature> features;
    protected List<Feature> labels;

    public TabularDataset(BaseBuilder<?> builder) {
        super(builder);
        this.features = builder.features;
        this.labels = builder.labels;
        if (this.features.isEmpty()) {
            throw new IllegalArgumentException("Missing features.");
        }
        if (this.labels.isEmpty() && !builder.allowNoLabels) {
            throw new IllegalArgumentException("Missing labels.");
        }
    }

    public int getFeatureSize() {
        return this.features.size();
    }

    public int getLabelSize() {
        return this.labels.size();
    }

    public Record get(NDManager manager, long index) {
        NDList data = this.getRowFeatures(manager, index, this.features);
        NDList label = this.labels.isEmpty() ? new NDList() : this.getRowFeatures(manager, index, this.labels);
        return new Record(data, label);
    }

    public NDList getRowFeatures(NDManager manager, long index, List<Feature> selected) {
        DynamicBuffer bb = new DynamicBuffer();
        for (Feature feature : selected) {
            String name = feature.getName();
            String value = this.getCell(index, name);
            feature.getFeaturizer().featurize(bb, value);
        }
        FloatBuffer buf = bb.getBuffer();
        return new NDList(new NDArray[]{manager.create((Buffer)buf, new Shape(new long[]{bb.getLength()}))});
    }

    protected void prepareFeaturizers() {
        int availableSize = Math.toIntExact(this.availableSize());
        ArrayList<Feature> featuresToPrepare = new ArrayList<Feature>(this.features.size() + this.labels.size());
        featuresToPrepare.addAll(this.features);
        featuresToPrepare.addAll(this.labels);
        for (Feature feature : featuresToPrepare) {
            if (!(feature.getFeaturizer() instanceof PreparedFeaturizer)) continue;
            PreparedFeaturizer featurizer = (PreparedFeaturizer)feature.getFeaturizer();
            ArrayList<String> inputs = new ArrayList<String>(Math.toIntExact(availableSize));
            for (int i = 0; i < availableSize; ++i) {
                inputs.add(this.getCell(i, feature.getName()));
            }
            featurizer.prepare(inputs);
        }
    }

    protected abstract String getCell(long var1, String var3);

    public static abstract class BaseBuilder<T extends BaseBuilder<T>>
    extends RandomAccessDataset.BaseBuilder<T> {
        protected List<Feature> features = new ArrayList<Feature>();
        protected List<Feature> labels = new ArrayList<Feature>();
        protected boolean allowNoLabels;

        protected BaseBuilder() {
        }

        public T addFeature(Feature ... features) {
            Collections.addAll(this.features, features);
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addNumericFeature(String name) {
            this.features.add(new Feature(name, true));
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addNumericFeature(String name, boolean normalize) {
            this.features.add(new Feature(name, Featurizers.getNumericFeaturizer(normalize)));
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addCategoricalFeature(String name) {
            this.features.add(new Feature(name, false));
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addCategoricalFeature(String name, boolean onehotEncode) {
            this.features.add(new Feature(name, Featurizers.getStringFeaturizer(onehotEncode)));
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addCategoricalFeature(String name, Map<String, Integer> map, boolean onehotEncode) {
            this.features.add(new Feature(name, map, onehotEncode));
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addLabel(Feature ... labels) {
            Collections.addAll(this.labels, labels);
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addNumericLabel(String name) {
            this.labels.add(new Feature(name, true));
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addNumericLabel(String name, boolean normalize) {
            this.labels.add(new Feature(name, Featurizers.getNumericFeaturizer(normalize)));
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addCategoricalLabel(String name) {
            this.labels.add(new Feature(name, false));
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addCategoricalLabel(String name, boolean onehotEncode) {
            this.labels.add(new Feature(name, Featurizers.getStringFeaturizer(onehotEncode)));
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T addCategoricalLabel(String name, Map<String, Integer> map, boolean onehotEncode) {
            this.labels.add(new Feature(name, map, onehotEncode));
            return (T)((Object)((BaseBuilder)this.self()));
        }

        public T noLabels() {
            this.allowNoLabels = true;
            return (T)((Object)((BaseBuilder)this.self()));
        }
    }
}

