/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.EngineException;
import ai.djl.engine.EngineProvider;
import ai.djl.ndarray.NDManager;
import ai.djl.training.GradientCollector;
import ai.djl.training.LocalParameterServer;
import ai.djl.training.ParameterServer;
import ai.djl.training.optimizer.Optimizer;
import ai.djl.util.cuda.CudaUtils;
import java.lang.management.MemoryUsage;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Engine {
    private static final Logger logger = LoggerFactory.getLogger(Engine.class);
    private static final Map<String, Engine> ALL_ENGINES = new ConcurrentHashMap<String, Engine>();
    private static final String DEFAULT_ENGINE = Engine.initEngine();
    private static EngineException exception;
    private Device defaultDevice;

    private static synchronized String initEngine() {
        ServiceLoader<EngineProvider> loaders = ServiceLoader.load(EngineProvider.class);
        for (EngineProvider provider : loaders) {
            try {
                Engine engine = provider.getEngine();
                logger.debug("Engine loaded from provider: {}", (Object)engine.getEngineName());
                ALL_ENGINES.put(engine.getEngineName(), engine);
            }
            catch (EngineException e) {
                exception = e;
                logger.warn("Failed to load engine from: " + provider.getClass().getName(), (Throwable)e);
            }
        }
        if (ALL_ENGINES.isEmpty()) {
            logger.debug("No engine found from EngineProvider");
            return null;
        }
        String defaultEngine = System.getenv("DJL_DEFAULT_ENGINE");
        if ((defaultEngine = System.getProperty("ai.djl.default_engine", defaultEngine)) == null || defaultEngine.isEmpty()) {
            if (ALL_ENGINES.size() > 1) {
                logger.warn("More than one deep learning engines found.");
            }
            int rank = Integer.MAX_VALUE;
            for (Engine engine : ALL_ENGINES.values()) {
                if (engine.getRank() >= rank) continue;
                defaultEngine = engine.getEngineName();
                rank = engine.getRank();
            }
        } else if (!ALL_ENGINES.containsKey(defaultEngine)) {
            throw new EngineException("Unknown default engine: " + defaultEngine);
        }
        logger.debug("Found default engine: {}", (Object)defaultEngine);
        return defaultEngine;
    }

    public abstract String getEngineName();

    public int getRank() {
        return 1;
    }

    public static Engine getInstance() {
        if (DEFAULT_ENGINE == null) {
            throw new EngineException("No deep learning engine found." + System.lineSeparator() + "Please refer to https://github.com/awslabs/djl/blob/master/docs/development/troubleshooting.md for more details.", exception);
        }
        return Engine.getEngine(System.getProperty("ai.djl.default_engine", DEFAULT_ENGINE));
    }

    public static boolean hasEngine(String engineName) {
        return ALL_ENGINES.containsKey(engineName);
    }

    public static Set<String> getAllEngines() {
        return ALL_ENGINES.keySet();
    }

    public static Engine getEngine(String engineName) {
        Engine engine = ALL_ENGINES.get(engineName);
        if (engine == null) {
            throw new IllegalArgumentException("Deep learning engine not found: " + engineName);
        }
        return engine;
    }

    public abstract String getVersion();

    public abstract boolean hasCapability(String var1);

    public Device defaultDevice() {
        if (this.defaultDevice == null) {
            this.defaultDevice = this.hasCapability("CUDA") && CudaUtils.getGpuCount() > 0 ? Device.gpu() : Device.cpu();
        }
        return this.defaultDevice;
    }

    public abstract Model newModel(String var1, Device var2);

    public abstract NDManager newBaseManager();

    public abstract NDManager newBaseManager(Device var1);

    public abstract GradientCollector newGradientCollector();

    public ParameterServer newParameterServer(Optimizer optimizer) {
        return new LocalParameterServer(optimizer);
    }

    public abstract void setRandomSeed(int var1);

    public static void debugEnvironment() {
        System.out.println("----------- System Properties -----------");
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> System.out.println(k + ": " + v)));
        System.out.println();
        System.out.println("--------- Environment Variables ---------");
        System.getenv().forEach((k, v) -> System.out.println(k + ": " + v));
        System.out.println();
        System.out.println("-------------- Directories --------------");
        try {
            Path temp = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
            System.out.println("temp directory: " + temp.toString());
            Files.createTempFile("test", ".tmp", new FileAttribute[0]);
            Path path = Engine.getEngineCacheDir();
            System.out.println("Engine cache directory: " + path.toAbsolutePath().toString());
            Files.createDirectories(path, new FileAttribute[0]);
            if (!Files.isWritable(path)) {
                System.out.println("Engine cache directory is not writable!!!");
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
        System.out.println();
        System.out.println("------------------ CUDA -----------------");
        int gpuCount = Device.getGpuCount();
        System.out.println("GPU Count: " + gpuCount);
        System.out.println("Default Device: " + Device.defaultDevice());
        if (gpuCount > 0) {
            System.out.println("CUDA: " + CudaUtils.getCudaVersionString());
            System.out.println("ARCH: " + CudaUtils.getComputeCapability(0));
        }
        for (int i = 0; i < gpuCount; ++i) {
            Device device = Device.gpu(i);
            MemoryUsage mem = CudaUtils.getGpuMemory(device);
            System.out.println("GPU(" + i + ") memory used: " + mem.getCommitted() + " bytes");
        }
        System.out.println();
        System.out.println("----------------- Engines ---------------");
        System.out.println("Default Engine: " + DEFAULT_ENGINE);
        for (Engine engine : ALL_ENGINES.values()) {
            System.out.println(engine);
        }
        if (exception != null) {
            System.out.println("Last error:");
            exception.printStackTrace(System.out);
        }
    }

    private static Path getEngineCacheDir() {
        String cacheDir = System.getProperty("ENGINE_CACHE_DIR");
        if (!(cacheDir != null && !cacheDir.isEmpty() || (cacheDir = System.getenv("ENGINE_CACHE_DIR")) != null && !cacheDir.isEmpty() || (cacheDir = System.getProperty("DJL_CACHE_DIR")) != null && !cacheDir.isEmpty() || (cacheDir = System.getenv("DJL_CACHE_DIR")) != null && !cacheDir.isEmpty())) {
            String userHome = System.getProperty("user.home");
            return Paths.get(userHome, ".djl.ai");
        }
        return Paths.get(cacheDir, new String[0]);
    }
}

