/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray;

import ai.djl.Device;
import ai.djl.ndarray.NDManager;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNDManager
implements NDManager {
    private static final Logger logger = LoggerFactory.getLogger(BaseNDManager.class);
    protected NDManager parent;
    protected String uid;
    protected Device device;
    protected Map<String, Reference<AutoCloseable>> resources;
    protected AtomicBoolean closed = new AtomicBoolean(false);

    protected BaseNDManager(NDManager parent, Device device) {
        this.parent = parent;
        this.device = Device.defaultIfNull(device);
        this.resources = new ConcurrentHashMap<String, Reference<AutoCloseable>>();
        this.uid = UUID.randomUUID().toString();
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public NDManager getParentManager() {
        return this.parent;
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    public String toString() {
        String parentUID = this.parent == null ? "No Parent" : ((BaseNDManager)this.parent).uid;
        return "UID: " + this.uid + " Parent UID: " + parentUID + " isOpen: " + this.isOpen() + " Resource size: " + this.resources.size();
    }

    @Override
    public synchronized void attach(String resourceId, AutoCloseable resource) {
        if (this.closed.get()) {
            throw new IllegalStateException("NDManager has been closed already.");
        }
        WeakReference ref = Boolean.getBoolean("ai.djl.disable_close_resource_on_finalize") ? new HardReference(resource) : new WeakReference<AutoCloseable>(resource);
        this.resources.put(resourceId, ref);
    }

    @Override
    public synchronized void detach(String resourceId) {
        if (this.closed.get()) {
            return;
        }
        this.resources.remove(resourceId);
    }

    @Override
    public synchronized void close() {
        if (!this.closed.getAndSet(true)) {
            for (Reference<AutoCloseable> resource : this.resources.values()) {
                AutoCloseable closeable = resource.get();
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    logger.error("Resource close failed.", (Throwable)e);
                }
            }
            this.parent.detach(this.uid);
            this.resources.clear();
        }
    }

    public void debugDump(int level) {
        StringBuilder sb = new StringBuilder(100);
        for (int i = 0; i < level; ++i) {
            sb.append("    ");
        }
        sb.append("\\--- NDManager(").append(this.uid.substring(24)).append(") resource count: ").append(this.resources.size());
        System.out.println(sb.toString());
        for (Reference<AutoCloseable> ref : this.resources.values()) {
            AutoCloseable c = ref.get();
            if (!(c instanceof BaseNDManager)) continue;
            ((BaseNDManager)c).debugDump(level + 1);
        }
    }

    private static final class HardReference
    extends WeakReference<AutoCloseable> {
        private AutoCloseable obj;

        HardReference(AutoCloseable obj) {
            super(obj);
            this.obj = obj;
        }

        private AutoCloseable getReference() {
            return this.obj;
        }
    }
}

