/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.Application;
import ai.djl.Model;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.transform.CenterCrop;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.translator.ImageClassificationTranslator;
import ai.djl.modality.cv.translator.SingleShotDetectionTranslator;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.Batchifier;
import ai.djl.translate.ServingTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.JsonUtils;
import ai.djl.util.PairList;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServingTranslatorFactory
implements TranslatorFactory<Input, Output> {
    private static final Logger logger = LoggerFactory.getLogger(ServingTranslatorFactory.class);

    @Override
    public Translator<Input, Output> newInstance(Model model, Map<String, Object> arguments) throws TranslateException {
        Path libPath;
        Path modelDir = model.getModelPath();
        String className = null;
        Path manifestFile = modelDir.resolve("serving.properties");
        if (Files.isRegularFile(manifestFile, new LinkOption[0])) {
            Properties prop = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(manifestFile);){
                prop.load(reader);
            }
            catch (IOException e) {
                throw new TranslateException("Failed to load serving.properties file", e);
            }
            for (String key : prop.stringPropertyNames()) {
                arguments.putIfAbsent(key, prop.getProperty(key));
            }
            className = prop.getProperty("translator");
        }
        if (!Files.isDirectory(libPath = modelDir.resolve("libs"), new LinkOption[0]) && !Files.isDirectory(libPath = modelDir.resolve("lib"), new LinkOption[0])) {
            return this.loadDefaultTranslator(arguments);
        }
        ServingTranslator translator = this.findTranslator(libPath, className);
        if (translator != null) {
            translator.setArguments(arguments);
            return translator;
        }
        return this.loadDefaultTranslator(arguments);
    }

    private ServingTranslator findTranslator(Path path, String className) {
        try {
            Path classesDir = path.resolve("classes");
            this.compileJavaClass(classesDir);
            List jarFiles = Files.list(path).filter(p -> p.toString().endsWith(".jar")).collect(Collectors.toList());
            ArrayList<URL> urls = new ArrayList<URL>(jarFiles.size() + 1);
            urls.add(classesDir.toUri().toURL());
            for (Path p2 : jarFiles) {
                urls.add(p2.toUri().toURL());
            }
            ClassLoader parentCl = Thread.currentThread().getContextClassLoader();
            URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]), parentCl);
            if (className != null && !className.isEmpty()) {
                return this.initTranslator(cl, className);
            }
            ServingTranslator translator = this.scanDirectory(cl, classesDir);
            if (translator != null) {
                return translator;
            }
            for (Path p3 : jarFiles) {
                translator = this.scanJarFile(cl, p3);
                if (translator == null) continue;
                return translator;
            }
        }
        catch (IOException e) {
            logger.debug("Failed to find Translator", (Throwable)e);
        }
        return null;
    }

    private ServingTranslator scanDirectory(ClassLoader cl, Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            logger.debug("Directory not exists: {}", (Object)dir);
            return null;
        }
        Collection files = Files.walk(dir, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".class")).collect(Collectors.toList());
        for (Path file : files) {
            Path p2 = dir.relativize(file);
            String className = p2.toString();
            className = className.substring(0, className.lastIndexOf(46));
            ServingTranslator translator = this.initTranslator(cl, className = className.replace(File.separatorChar, '.'));
            if (translator == null) continue;
            return translator;
        }
        return null;
    }

    private ServingTranslator scanJarFile(ClassLoader cl, Path path) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String fileName = entry.getName();
                if (!fileName.endsWith(".class")) continue;
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
                ServingTranslator translator = this.initTranslator(cl, fileName = fileName.replace('/', '.'));
                if (translator == null) continue;
                ServingTranslator servingTranslator = translator;
                return servingTranslator;
            }
        }
        return null;
    }

    private ServingTranslator initTranslator(ClassLoader cl, String className) {
        try {
            Class<?> clazz = Class.forName(className, true, cl);
            Class<ServingTranslator> subclass = clazz.asSubclass(ServingTranslator.class);
            Constructor<ServingTranslator> constructor = subclass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            logger.trace("Not able to load ModelServerTranslator", e);
            return null;
        }
    }

    private Translator<Input, Output> loadDefaultTranslator(Map<String, Object> arguments) {
        String appName = (String)arguments.get("application");
        if (appName != null) {
            Application application = Application.of(appName);
            if (application == Application.CV.IMAGE_CLASSIFICATION) {
                return this.getImageClassificationTranslator(arguments);
            }
            if (application == Application.CV.OBJECT_DETECTION) {
                return this.getSsdTranslator(arguments);
            }
        }
        return new RawTranslator();
    }

    private Translator<Input, Output> getImageClassificationTranslator(Map<String, Object> arguments) {
        int width = ServingTranslatorFactory.getOrDefault(arguments, "width", 224.0).intValue();
        int height = ServingTranslatorFactory.getOrDefault(arguments, "height", 224.0).intValue();
        String flag = arguments.getOrDefault("flag", Image.Flag.COLOR.name()).toString();
        boolean softmax = Boolean.parseBoolean(arguments.getOrDefault("softmax", false).toString());
        ImageClassificationTranslator translator = ((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)ImageClassificationTranslator.builder().optFlag(Image.Flag.valueOf(flag))).addTransform(new CenterCrop())).addTransform(new Resize(width, height))).addTransform(new ToTensor())).optApplySoftmax(softmax).build();
        return new ImageServingTranslator(translator);
    }

    private Translator<Input, Output> getSsdTranslator(Map<String, Object> arguments) {
        int width = ServingTranslatorFactory.getOrDefault(arguments, "width", 512.0).intValue();
        int height = ServingTranslatorFactory.getOrDefault(arguments, "height", 512.0).intValue();
        double threshold = ServingTranslatorFactory.getOrDefault(arguments, "threshold", 0.2);
        String flag = arguments.getOrDefault("flag", Image.Flag.COLOR.name()).toString();
        String synset = arguments.getOrDefault("synset", "synset.txt").toString();
        SingleShotDetectionTranslator translator = ((SingleShotDetectionTranslator.Builder)((SingleShotDetectionTranslator.Builder)((SingleShotDetectionTranslator.Builder)((SingleShotDetectionTranslator.Builder)((SingleShotDetectionTranslator.Builder)((SingleShotDetectionTranslator.Builder)SingleShotDetectionTranslator.builder().optFlag(Image.Flag.valueOf(flag))).addTransform(new Resize(width, height))).addTransform(new ToTensor())).optThreshold((float)threshold)).optRescaleSize(width, height)).optSynsetArtifactName(synset)).build();
        return new ImageServingTranslator(translator);
    }

    private void compileJavaClass(Path dir) {
        try {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                logger.debug("Directory not exists: {}", (Object)dir);
                return;
            }
            String[] files = (String[])Files.walk(dir, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".java")).map(p -> p.toAbsolutePath().toString()).toArray(String[]::new);
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (files.length > 0) {
                compiler.run(null, null, null, files);
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to compile bundled java file", e);
        }
    }

    private static Double getOrDefault(Map<String, Object> arguments, String key, double defaultValue) {
        Object value = arguments.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Double.valueOf(value.toString());
    }

    private static final class RawTranslator
    implements Translator<Input, Output> {
        private RawTranslator() {
        }

        @Override
        public Batchifier getBatchifier() {
            return null;
        }

        @Override
        public NDList processInput(TranslatorContext ctx, Input input) throws IOException {
            ctx.setAttachment("input", input);
            PairList<String, byte[]> inputs = input.getContent();
            byte[] data = inputs.get("data");
            if (data == null) {
                data = inputs.get("body");
            }
            if (data == null) {
                data = input.getContent().valueAt(0);
            }
            NDManager manager = ctx.getNDManager();
            return NDList.decode(manager, data);
        }

        @Override
        public Output processOutput(TranslatorContext ctx, NDList list) {
            Input input = (Input)ctx.getAttachment("input");
            Output output = new Output(input.getRequestId(), 200, "OK");
            output.setContent(list.encode());
            return output;
        }
    }

    private static final class ImageServingTranslator
    implements Translator<Input, Output> {
        private Translator<Image, ?> translator;
        private ImageFactory factory;

        public ImageServingTranslator(Translator<Image, ?> translator) {
            this.translator = translator;
            this.factory = ImageFactory.getInstance();
        }

        @Override
        public Batchifier getBatchifier() {
            return this.translator.getBatchifier();
        }

        @Override
        public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
            Input input = (Input)ctx.getAttachment("input");
            Output output = new Output(input.getRequestId(), 200, "OK");
            Object obj = this.translator.processOutput(ctx, list);
            output.setContent(JsonUtils.GSON_PRETTY.toJson(obj) + '\n');
            return output;
        }

        @Override
        public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
            ctx.setAttachment("input", input);
            PairList<String, byte[]> inputs = input.getContent();
            byte[] data = inputs.get("data");
            if (data == null) {
                data = inputs.get("body");
            }
            if (data == null) {
                data = input.getContent().valueAt(0);
            }
            Image image = this.factory.fromInputStream(new ByteArrayInputStream(data));
            return this.translator.processInput(ctx, image);
        }

        @Override
        public void prepare(NDManager manager, Model model) throws IOException {
            this.translator.prepare(manager, model);
        }
    }
}

