/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.translator.BaseImageTranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.List;

public class ImageClassificationTranslator
extends BaseImageTranslator<Classifications> {
    private BaseImageTranslator.SynsetLoader synsetLoader;
    private boolean applySoftmax;
    private List<String> classes;

    public ImageClassificationTranslator(Builder builder) {
        super(builder);
        this.synsetLoader = builder.synsetLoader;
        this.applySoftmax = builder.applySoftmax;
    }

    @Override
    public void prepare(NDManager manager, Model model) throws IOException {
        if (this.classes == null) {
            this.classes = this.synsetLoader.load(model);
        }
    }

    @Override
    public Classifications processOutput(TranslatorContext ctx, NDList list) {
        NDArray probabilitiesNd = list.singletonOrThrow();
        if (this.applySoftmax) {
            probabilitiesNd = probabilitiesNd.softmax(0);
        }
        return new Classifications(this.classes, probabilitiesNd);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseImageTranslator.ClassificationBuilder<Builder> {
        private boolean applySoftmax;

        Builder() {
        }

        public Builder optApplySoftmax(boolean applySoftmax) {
            this.applySoftmax = applySoftmax;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ImageClassificationTranslator build() {
            this.validate();
            return new ImageClassificationTranslator(this);
        }
    }
}

