/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Transform;
import ai.djl.util.Pair;
import ai.djl.util.PairList;
import java.util.concurrent.ConcurrentHashMap;

public class Pipeline {
    private PairList<IndexKey, Transform> transforms = new PairList();

    public Pipeline() {
    }

    public Pipeline(Transform ... transforms) {
        for (Transform transform : transforms) {
            this.transforms.add(new IndexKey(0), transform);
        }
    }

    public Pipeline add(Transform transform) {
        this.transforms.add(new IndexKey(0), transform);
        return this;
    }

    public Pipeline add(int index, Transform transform) {
        this.transforms.add(new IndexKey(index), transform);
        return this;
    }

    public Pipeline add(String name, Transform transform) {
        this.transforms.add(new IndexKey(name), transform);
        return this;
    }

    public Pipeline insert(int position, Transform transform) {
        this.transforms.add(position, new IndexKey(0), transform);
        return this;
    }

    public Pipeline insert(int position, int index, Transform transform) {
        this.transforms.add(position, new IndexKey(index), transform);
        return this;
    }

    public Pipeline insert(int position, String name, Transform transform) {
        this.transforms.add(position, new IndexKey(name), transform);
        return this;
    }

    public NDList transform(NDList input) {
        if (this.transforms.isEmpty() || input.isEmpty()) {
            return input;
        }
        NDArray[] arrays = input.toArray(new NDArray[0]);
        ConcurrentHashMap<IndexKey, Integer> map = new ConcurrentHashMap<IndexKey, Integer>();
        for (int i = 0; i < input.size(); ++i) {
            String string = ((NDArray)input.get(i)).getName();
            if (string != null) {
                map.put(new IndexKey(string), i);
            }
            map.put(new IndexKey(i), i);
        }
        for (Pair<IndexKey, Transform> pair : this.transforms) {
            IndexKey key = pair.getKey();
            int index = (Integer)map.get(key);
            NDArray array = arrays[index];
            arrays[index] = pair.getValue().transform(array);
            arrays[index].setName(array.getName());
        }
        return new NDList(arrays);
    }

    private static final class IndexKey {
        private String key;
        private int index;

        private IndexKey(String key) {
            this.key = key;
        }

        private IndexKey(int index) {
            this.index = index;
        }

        public int hashCode() {
            if (this.key == null) {
                return this.index;
            }
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IndexKey)) {
                return false;
            }
            IndexKey other = (IndexKey)obj;
            if (this.key == null) {
                return this.index == other.index;
            }
            return this.key.equals(other.key);
        }
    }
}

