/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import ai.djl.repository.Anchor;
import java.net.URI;

public class MRL {
    private Anchor baseAnchor;
    private String groupId;
    private String artifactId;

    MRL(Anchor baseAnchor, String groupId, String artifactId) {
        this.baseAnchor = baseAnchor;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public static MRL model(Application application, String groupId, String artifactId) {
        Anchor baseAnchor = Anchor.MODEL.resolve(application.getPath());
        return new MRL(baseAnchor, groupId, artifactId);
    }

    public static MRL dataset(Application application, String groupId, String artifactId) {
        Anchor baseAnchor = Anchor.DATASET.resolve(application.getPath()).getParent();
        return new MRL(baseAnchor, groupId, artifactId);
    }

    public static MRL undefined(String groupId, String artifactId) {
        return new MRL(new Anchor(new String[0]), groupId, artifactId);
    }

    public URI toURI() {
        String groupIdPath = this.groupId.replace('.', '/');
        Anchor anchor = this.baseAnchor.resolve(groupIdPath, this.artifactId);
        return URI.create(anchor.getPath() + '/');
    }

    public Anchor getBaseAnchor() {
        return this.baseAnchor;
    }

    public void setBaseAnchor(Anchor baseAnchor) {
        this.baseAnchor = baseAnchor;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String toString() {
        return this.toURI().toString();
    }
}

