/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.preprocess;

import ai.djl.modality.nlp.preprocess.TextProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PunctuationSeparator
implements TextProcessor {
    private static final String DEFAULT_PUNCTUATIONS = ".,!?";
    private String punctuations;

    public PunctuationSeparator(String punctuations) {
        this.punctuations = punctuations;
    }

    public PunctuationSeparator() {
        this(DEFAULT_PUNCTUATIONS);
    }

    @Override
    public List<String> preprocess(List<String> tokens) {
        ArrayList<String> list = new ArrayList<String>();
        for (String token : tokens) {
            StringTokenizer tokenizer = new StringTokenizer(token, this.punctuations, true);
            while (tokenizer.hasMoreElements()) {
                String element = tokenizer.nextToken();
                if (element.isEmpty()) continue;
                list.add(element);
            }
        }
        return list;
    }
}

