/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.embedding;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.modality.nlp.embedding.EmbeddingException;
import ai.djl.modality.nlp.embedding.WordEmbedding;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.nn.core.Embedding;
import ai.djl.translate.NoopTranslator;
import ai.djl.translate.TranslateException;

public class ModelZooWordEmbedding
implements WordEmbedding,
AutoCloseable {
    private Predictor<NDList, NDList> predictor;
    private Embedding<String> embedding;
    private String unknownToken;

    public ModelZooWordEmbedding(Model model) {
        this.unknownToken = model.getProperty("unknownToken");
        this.predictor = model.newPredictor(new NoopTranslator());
        try {
            this.embedding = (Embedding)model.getBlock();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The model was not an embedding", e);
        }
    }

    @Override
    public boolean vocabularyContains(String word) {
        return this.embedding.hasItem(word);
    }

    @Override
    public int preprocessWordToEmbed(String word) {
        if (this.embedding.hasItem(word)) {
            return this.embedding.embed(word);
        }
        return this.embedding.embed(this.unknownToken);
    }

    @Override
    public NDArray embedWord(NDManager manager, int word) throws EmbeddingException {
        try {
            return this.predictor.predict(new NDList(manager.create(word))).singletonOrThrow();
        }
        catch (TranslateException e) {
            throw new EmbeddingException("Could not embed word", e);
        }
    }

    @Override
    public String unembedWord(NDArray word) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void close() {
        this.predictor.close();
    }
}

