/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.output;

import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.PathIterator;
import ai.djl.modality.cv.output.Point;
import java.awt.Graphics2D;

public class Rectangle
implements BoundingBox {
    private static final long serialVersionUID = 1L;
    private Point point;
    private double width;
    private double height;

    public Rectangle(double x, double y, double width, double height) {
        this(new Point(x, y), width, height);
    }

    public Rectangle(Point point, double width, double height) {
        this.point = point;
        this.width = width;
        this.height = height;
    }

    @Override
    public Rectangle getBounds() {
        return this;
    }

    @Override
    public PathIterator getPath() {
        return new PathIterator(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < 4;
            }

            @Override
            public void next() {
                if (this.index > 3) {
                    throw new IllegalStateException("No more path in iterator.");
                }
                ++this.index;
            }

            @Override
            public Point currentPoint() {
                switch (this.index) {
                    case 0: {
                        return Rectangle.this.point;
                    }
                    case 1: {
                        return new Point(Rectangle.this.point.getX() + Rectangle.this.width, Rectangle.this.point.getY());
                    }
                    case 2: {
                        return new Point(Rectangle.this.point.getX() + Rectangle.this.width, Rectangle.this.point.getY() + Rectangle.this.height);
                    }
                    case 3: {
                        return new Point(Rectangle.this.point.getX(), Rectangle.this.point.getY() + Rectangle.this.height);
                    }
                }
                throw new AssertionError((Object)("Invalid index: " + this.index));
            }
        };
    }

    @Override
    public Point getPoint() {
        return this.point;
    }

    @Override
    public double getIoU(BoundingBox box) {
        Rectangle rec = (Rectangle)box;
        double left = Math.max(this.getX(), rec.getX());
        double top = Math.min(this.getY(), rec.getY());
        double right = Math.min(this.getX() + this.getWidth(), rec.getX() + rec.getWidth());
        double bottom = Math.min(this.getY() + this.getHeight(), rec.getY() + rec.getHeight());
        double intersection = (right - left) * (bottom - top);
        return intersection / (this.getWidth() * this.getHeight() + rec.getWidth() * rec.getHeight() - intersection);
    }

    @Override
    public void draw(Graphics2D g, int imageWidth, int imageHeight) {
        int x = (int)(this.getX() * (double)imageWidth);
        int y = (int)(this.getY() * (double)imageHeight);
        int w = (int)(this.getWidth() * (double)imageWidth);
        int h = (int)(this.getHeight() * (double)imageHeight);
        g.drawRect(x, y, w, h);
    }

    public double getX() {
        return this.point.getX();
    }

    public double getY() {
        return this.point.getY();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public String toString() {
        double x = this.point.getX();
        double y = this.point.getY();
        return String.format("[x=%.3f, y=%.3f, width=%.3f, height=%.3f]", x, y, this.width, this.height);
    }
}

