/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.translator.ImageTranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.Utils;
import java.io.IOException;
import java.util.List;

public class ImageClassificationTranslator
extends ImageTranslator<Classifications> {
    private String synsetArtifactName;
    private boolean applySoftmax;
    private List<String> synset;

    public ImageClassificationTranslator(Builder builder) {
        super(builder);
        this.synsetArtifactName = builder.synsetArtifactName;
        this.applySoftmax = builder.applySoftmax;
    }

    @Override
    public void prepare(NDManager manager, Model model) throws IOException {
        this.synset = model.getArtifact(this.synsetArtifactName, Utils::readLines);
    }

    @Override
    public Classifications processOutput(TranslatorContext ctx, NDList list) throws IOException {
        NDArray probabilitiesNd = list.singletonOrThrow();
        if (this.applySoftmax) {
            probabilitiesNd = probabilitiesNd.softmax(0);
        }
        return new Classifications(this.synset, probabilitiesNd);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImageTranslator.BaseBuilder<Builder> {
        private String synsetArtifactName;
        private boolean applySoftmax;

        Builder() {
        }

        public Builder setSynsetArtifactName(String synsetArtifactName) {
            this.synsetArtifactName = synsetArtifactName;
            return this;
        }

        public Builder optApplySoftmax(boolean applySoftmax) {
            this.applySoftmax = applySoftmax;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ImageClassificationTranslator build() {
            if (this.synsetArtifactName == null) {
                throw new IllegalArgumentException("You must specify a synset artifact name");
            }
            return new ImageClassificationTranslator(this);
        }
    }
}

