/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Joints;
import ai.djl.modality.cv.output.Landmark;
import ai.djl.modality.cv.output.Mask;
import ai.djl.modality.cv.output.Point;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.util.RandomUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;

public class BufferedImageFactory
extends ImageFactory {
    @Override
    public Image fromFile(Path path) throws IOException {
        BufferedImage image = ImageIO.read(path.toFile());
        if (image == null) {
            throw new IOException("Failed to read image from: " + path);
        }
        return new BufferedImageWrapper(image);
    }

    @Override
    public Image fromInputStream(InputStream is) throws IOException {
        BufferedImage image = ImageIO.read(is);
        if (image == null) {
            throw new IOException("Failed to read image from input stream");
        }
        return new BufferedImageWrapper(image);
    }

    @Override
    public Image fromImage(Object image) {
        if (!(image instanceof BufferedImage)) {
            throw new IllegalArgumentException("only BufferedImage allowed");
        }
        return new BufferedImageWrapper((BufferedImage)image);
    }

    @Override
    public Image fromNDArray(NDArray array) {
        Shape shape = array.getShape();
        if (shape.dimension() == 4) {
            throw new UnsupportedOperationException("Batch is not supported");
        }
        if (shape.get(0) == 1L || shape.get(2) == 1L) {
            throw new UnsupportedOperationException("Grayscale image is not supported");
        }
        int[] raw = array.toType(DataType.UINT8, false).toUint8Array();
        if (NDImageUtils.isCHW(shape)) {
            int height = (int)shape.get(1);
            int width = (int)shape.get(2);
            BufferedImage image = new BufferedImage(width, height, 1);
            int[] pixels = new int[width * height];
            int imageArea = height * width;
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int index = h * width + w;
                    int red = raw[index];
                    int green = raw[imageArea + index];
                    int blue = raw[imageArea * 2 + index];
                    pixels[index] = red << 16 | green << 8 | blue;
                }
            }
            image.setRGB(0, 0, width, height, pixels, 0, width);
            return new BufferedImageWrapper(image);
        }
        int height = (int)shape.get(0);
        int width = (int)shape.get(1);
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] pixels = new int[width * height];
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                int index = h * width + w;
                int pos = index * 3;
                int red = raw[pos];
                int green = raw[pos + 1];
                int blue = raw[pos + 2];
                pixels[index] = red << 16 | green << 8 | blue;
            }
        }
        image.setRGB(0, 0, width, height, pixels, 0, width);
        return new BufferedImageWrapper(image);
    }

    @Override
    public Image fromPixels(int[] pixels, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        image.setRGB(0, 0, width, height, pixels, 0, width);
        return new BufferedImageWrapper(image);
    }

    protected void save(BufferedImage image, OutputStream os, String type) throws IOException {
        ImageIO.write((RenderedImage)image, type, os);
    }

    static {
        if (System.getProperty("apple.awt.UIElement") == null) {
            System.setProperty("apple.awt.UIElement", "true");
        }
    }

    private class BufferedImageWrapper
    implements Image {
        private BufferedImage image;

        BufferedImageWrapper(BufferedImage image) {
            this.image = image;
        }

        @Override
        public int getWidth() {
            return this.image.getWidth();
        }

        @Override
        public int getHeight() {
            return this.image.getHeight();
        }

        @Override
        public BufferedImage getWrappedImage() {
            return this.image;
        }

        @Override
        public BufferedImageWrapper resize(int width, int height, boolean copy) {
            if (!copy && this.image.getWidth() == width && this.image.getHeight() == height) {
                return this;
            }
            java.awt.Image img = this.image.getScaledInstance(width, height, 4);
            BufferedImage scaled = new BufferedImage(width, height, this.image.getType());
            Graphics2D g2d = scaled.createGraphics();
            g2d.drawImage(img, 0, 0, null);
            g2d.dispose();
            return new BufferedImageWrapper(scaled);
        }

        @Override
        public Image getSubImage(int x, int y, int w, int h) {
            return new BufferedImageWrapper(this.image.getSubimage(x, y, w, h));
        }

        @Override
        public Image duplicate() {
            BufferedImage copy = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.image.getType());
            byte[] sourceData = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
            byte[] biData = ((DataBufferByte)copy.getRaster().getDataBuffer()).getData();
            System.arraycopy(sourceData, 0, biData, 0, sourceData.length);
            return new BufferedImageWrapper(copy);
        }

        @Override
        public Image getMask(int[][] mask) {
            int w = mask[0].length;
            int h = mask.length;
            BufferedImageWrapper resized = this.resize(w, h, true);
            BufferedImage img = resized.getWrappedImage();
            int[] pixels = new int[w * h];
            int index = 0;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    if (mask[y][x] != 0) {
                        pixels[index] = img.getRGB(x, y);
                    }
                    ++index;
                }
            }
            return BufferedImageFactory.this.fromPixels(pixels, w, h);
        }

        private void convertIdNeeded() {
            if (this.image.getType() == 2) {
                return;
            }
            BufferedImage newImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
            Graphics2D g = newImage.createGraphics();
            g.drawImage((java.awt.Image)this.image, 0, 0, null);
            g.dispose();
            this.image = newImage;
        }

        @Override
        public NDArray toNDArray(NDManager manager, Image.Flag flag) {
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            int channel = flag == Image.Flag.GRAYSCALE ? 1 : 3;
            ByteBuffer bb = manager.allocateDirect(channel * height * width);
            if (this.image.getType() == 10) {
                int[] data = new int[width * height];
                this.image.getData().getPixels(0, 0, width, height, data);
                for (int gray : data) {
                    byte b = (byte)gray;
                    bb.put(b);
                    if (flag == Image.Flag.GRAYSCALE) continue;
                    bb.put(b);
                    bb.put(b);
                }
            } else {
                int[] pixels;
                for (int rgb : pixels = this.image.getRGB(0, 0, width, height, null, 0, width)) {
                    int red = rgb >> 16 & 0xFF;
                    int green = rgb >> 8 & 0xFF;
                    int blue = rgb & 0xFF;
                    if (flag == Image.Flag.GRAYSCALE) {
                        int gray = Math.round(0.299f * (float)red + 0.587f * (float)green + 0.114f * (float)blue);
                        bb.put((byte)gray);
                        continue;
                    }
                    bb.put((byte)red);
                    bb.put((byte)green);
                    bb.put((byte)blue);
                }
            }
            bb.rewind();
            return manager.create(bb, new Shape(height, width, channel), DataType.UINT8);
        }

        @Override
        public void save(OutputStream os, String type) throws IOException {
            BufferedImageFactory.this.save(this.image, os, type);
        }

        @Override
        public List<BoundingBox> findBoundingBoxes() {
            throw new UnsupportedOperationException("Not supported for BufferedImage");
        }

        @Override
        public void drawBoundingBoxes(DetectedObjects detections, float opacity) {
            this.convertIdNeeded();
            Graphics2D g = (Graphics2D)this.image.getGraphics();
            int stroke = 2;
            g.setStroke(new BasicStroke(stroke));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int imageWidth = this.image.getWidth();
            int imageHeight = this.image.getHeight();
            List list = detections.items();
            int k = 10;
            ConcurrentHashMap<String, Integer> classNumberTable = new ConcurrentHashMap<String, Integer>();
            for (DetectedObjects.DetectedObject result : list) {
                String className = result.getClassName();
                BoundingBox box = result.getBoundingBox();
                if (classNumberTable.containsKey(className)) {
                    g.setPaint(new Color((Integer)classNumberTable.get(className)));
                } else {
                    g.setPaint(new Color(k));
                    classNumberTable.put(className, k);
                    k = (k + 100) % 255;
                }
                if (!className.isEmpty()) {
                    Rectangle rectangle = box.getBounds();
                    int x = (int)(rectangle.getX() * (double)imageWidth);
                    int y = (int)(rectangle.getY() * (double)imageHeight);
                    g.drawRect(x, y, (int)(rectangle.getWidth() * (double)imageWidth), (int)(rectangle.getHeight() * (double)imageHeight));
                    this.drawText(g, className, x, y, stroke, 4);
                }
                if (box instanceof Mask) {
                    this.drawMask((Mask)box, opacity);
                    continue;
                }
                if (!(box instanceof Landmark)) continue;
                this.drawLandmarks(box);
            }
            g.dispose();
        }

        @Override
        public void drawRectangle(Rectangle rect, int rgb, int thickness) {
            Graphics2D g = (Graphics2D)this.image.getGraphics();
            g.setStroke(new BasicStroke(thickness));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setPaint(new Color(rgb));
            int x = (int)rect.getX();
            int y = (int)rect.getY();
            g.drawRect(x, y, (int)rect.getWidth(), (int)rect.getHeight());
        }

        @Override
        public void drawMarks(List<Point> points, int radius) {
            Graphics2D g = (Graphics2D)this.image.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(new Color(246, 96, 0));
            for (Point point : points) {
                int[][] star = this.createStar(point, radius);
                g.fillPolygon(star[0], star[1], 10);
            }
            g.dispose();
        }

        @Override
        public void drawJoints(Joints joints) {
            this.convertIdNeeded();
            Graphics2D g = (Graphics2D)this.image.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int imageWidth = this.image.getWidth();
            int imageHeight = this.image.getHeight();
            List<Joints.Joint> list = joints.getJoints();
            if (list.size() == 17) {
                g.setColor(new Color(224, 255, 37));
                g.setStroke(new BasicStroke(3.0f));
                this.drawLine(g, list.get(5), list.get(7), imageWidth, imageHeight);
                this.drawLine(g, list.get(7), list.get(9), imageWidth, imageHeight);
                this.drawLine(g, list.get(6), list.get(8), imageWidth, imageHeight);
                this.drawLine(g, list.get(8), list.get(10), imageWidth, imageHeight);
                this.drawLine(g, list.get(11), list.get(13), imageWidth, imageHeight);
                this.drawLine(g, list.get(12), list.get(14), imageWidth, imageHeight);
                this.drawLine(g, list.get(13), list.get(15), imageWidth, imageHeight);
                this.drawLine(g, list.get(14), list.get(16), imageWidth, imageHeight);
                this.drawLine(g, list.get(5), list.get(6), imageWidth, imageHeight);
                this.drawLine(g, list.get(11), list.get(12), imageWidth, imageHeight);
                this.drawLine(g, list.get(5), list.get(11), imageWidth, imageHeight);
                this.drawLine(g, list.get(6), list.get(12), imageWidth, imageHeight);
            }
            g.setColor(new Color(37, 150, 190));
            g.setStroke(new BasicStroke(2.0f));
            for (Joints.Joint joint : list) {
                int x = (int)(joint.getX() * (double)imageWidth);
                int y = (int)(joint.getY() * (double)imageHeight);
                g.fillOval(x - 6, y - 6, 12, 12);
            }
            g.dispose();
        }

        @Override
        public void drawImage(Image overlay, boolean resize) {
            if (!(overlay.getWrappedImage() instanceof BufferedImage)) {
                throw new IllegalArgumentException("Only BufferedImage allowed");
            }
            if (resize) {
                overlay = overlay.resize(this.getWidth(), this.getHeight(), false);
            }
            BufferedImage target = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D g = (Graphics2D)target.getGraphics();
            g.drawImage((java.awt.Image)this.image, 0, 0, null);
            g.drawImage((java.awt.Image)((BufferedImage)overlay.getWrappedImage()), 0, 0, null);
            g.dispose();
            this.image = target;
        }

        private void drawLine(Graphics2D g, Joints.Joint from, Joints.Joint to, int width, int height) {
            int x0 = (int)(from.getX() * (double)width);
            int y0 = (int)(from.getY() * (double)height);
            int x1 = (int)(to.getX() * (double)width);
            int y1 = (int)(to.getY() * (double)height);
            g.drawLine(x0, y0, x1, y1);
        }

        private void drawText(Graphics2D g, String text, int x, int y, int stroke, int padding) {
            FontMetrics metrics = g.getFontMetrics();
            int width = metrics.stringWidth(text) + padding * 2 - stroke / 2;
            int height = metrics.getHeight() + metrics.getDescent();
            int ascent = metrics.getAscent();
            java.awt.Rectangle background = new java.awt.Rectangle(x += stroke / 2, y += stroke / 2, width, height);
            g.fill(background);
            g.setPaint(Color.WHITE);
            g.drawString(text, x + padding, y + ascent);
        }

        private void drawMask(Mask mask, float ratio) {
            float r = RandomUtils.nextFloat();
            float g = RandomUtils.nextFloat();
            float b = RandomUtils.nextFloat();
            int imageWidth = this.image.getWidth();
            int imageHeight = this.image.getHeight();
            int x = 0;
            int y = 0;
            int w = imageWidth;
            int h = imageHeight;
            if (!mask.isFullImageMask()) {
                x = (int)(mask.getX() * (double)imageWidth);
                y = (int)(mask.getY() * (double)imageHeight);
                w = (int)(mask.getWidth() * (double)imageWidth);
                h = (int)(mask.getHeight() * (double)imageHeight);
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
            }
            float[][] probDist = mask.getProbDist();
            if (ratio < 0.0f || ratio > 1.0f) {
                float max = 0.0f;
                float[][] fArray = probDist;
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    float[] row;
                    for (float f : row = fArray[i]) {
                        max = Math.max(max, f);
                    }
                }
                ratio = 0.5f / max;
            }
            BufferedImage maskImage = new BufferedImage(probDist[0].length, probDist.length, 2);
            for (int yCor = 0; yCor < probDist.length; ++yCor) {
                for (int xCor = 0; xCor < probDist[0].length; ++xCor) {
                    float opacity = probDist[yCor][xCor] * ratio;
                    maskImage.setRGB(xCor, yCor, new Color(r, g, b, opacity).darker().getRGB());
                }
            }
            java.awt.Image scaled = maskImage.getScaledInstance(w, h, 4);
            Graphics2D gR = (Graphics2D)this.image.getGraphics();
            gR.drawImage(scaled, x, y, null);
            gR.dispose();
        }

        private void drawLandmarks(BoundingBox box) {
            Graphics2D g = (Graphics2D)this.image.getGraphics();
            g.setColor(new Color(246, 96, 0));
            BasicStroke bStroke = new BasicStroke(4.0f, 0, 0);
            g.setStroke(bStroke);
            for (Point point : box.getPath()) {
                g.drawRect((int)point.getX(), (int)point.getY(), 2, 2);
            }
            g.dispose();
        }
    }
}

