/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.engine.rpc;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.engine.rpc.RpcModel;
import ai.djl.ndarray.NDManager;
import ai.djl.util.passthrough.PassthroughNDManager;

public class RpcEngine
extends Engine {
    public static final String ENGINE_NAME = "RPC";
    static final int RANK = 15;
    private Engine alternativeEngine;
    private boolean initialized;

    static Engine newInstance() {
        return new RpcEngine();
    }

    @Override
    public Engine getAlternativeEngine() {
        if (!this.initialized && !Boolean.getBoolean("ai.djl.java.disable_alternative")) {
            Engine engine = Engine.getInstance();
            if (engine.getRank() < this.getRank()) {
                this.alternativeEngine = engine;
            }
            this.initialized = true;
        }
        return this.alternativeEngine;
    }

    @Override
    public String getEngineName() {
        return ENGINE_NAME;
    }

    @Override
    public int getRank() {
        return 15;
    }

    @Override
    public String getVersion() {
        return Engine.class.getPackage().getSpecificationVersion();
    }

    @Override
    public boolean hasCapability(String capability) {
        return false;
    }

    @Override
    public Model newModel(String name, Device device) {
        return new RpcModel(name);
    }

    @Override
    public NDManager newBaseManager() {
        return this.newBaseManager(null);
    }

    @Override
    public NDManager newBaseManager(Device device) {
        return PassthroughNDManager.INSTANCE;
    }
}

